/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client.widgets.dialogs;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.overlord.sramp.ui.client.services.Services;
import org.overlord.sramp.ui.client.services.i18n.ILocalizationService;
import org.overlord.sramp.ui.client.widgets.dialogs.DialogBox;
import org.overlord.sramp.ui.shared.rsvcs.RemoteServiceException;

public class ErrorDialog
extends DialogBox {
    public ErrorDialog(String title, String message, RemoteServiceException error) {
        super(title);
        this.addStyleName("errorDialog");
        ILocalizationService i18n = Services.getServices().getService(ILocalizationService.class);
        FlowPanel contentWrapper = new FlowPanel();
        contentWrapper.setStyleName("errorDialogContent");
        Button closeButton = new Button(i18n.translate("dialogs.close", new Object[0]));
        contentWrapper.add((Widget)new InlineLabel(message));
        Label divider = new Label();
        divider.setStyleName("divider");
        VerticalPanel vpanel = new VerticalPanel();
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.setStyleName("errorButtonPanel");
        buttonPanel.addStyleName("buttonPanel");
        buttonPanel.add((Widget)closeButton);
        vpanel.add((Widget)contentWrapper);
        if (error != null) {
            TextArea stacktracePanel = new TextArea();
            stacktracePanel.setValue((Object)error.getRootStackTrace());
            stacktracePanel.setStyleName("stacktrace");
            stacktracePanel.getElement().setAttribute("wrap", "off");
            vpanel.add((Widget)stacktracePanel);
        }
        vpanel.add((Widget)divider);
        vpanel.add((Widget)buttonPanel);
        this.setWidget((Widget)vpanel);
        closeButton.setStyleName("closeButton");
        closeButton.addStyleName("button");
        closeButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ErrorDialog.this.hide();
            }
        });
    }

    @Override
    protected void handleEscapePressed() {
        this.hide();
    }
}

