/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.server.rsvcs;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Person;
import org.overlord.sramp.client.SrampClientUtils;
import org.overlord.sramp.client.SrampServerException;
import org.overlord.sramp.ui.server.api.SrampAtomApiClient;
import org.overlord.sramp.ui.server.util.ExceptionUtils;
import org.overlord.sramp.ui.shared.beans.ArtifactDetails;
import org.overlord.sramp.ui.shared.rsvcs.IArtifactRemoteService;
import org.overlord.sramp.ui.shared.rsvcs.RemoteServiceException;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;

public class ArtifactRemoteService
extends RemoteServiceServlet
implements IArtifactRemoteService {
    private static final long serialVersionUID = ArtifactRemoteService.class.hashCode();

    @Override
    public ArtifactDetails getArtifactDetails(String model, String type, String artifactUUID) throws RemoteServiceException {
        try {
            Entry entry = SrampAtomApiClient.getInstance().getFullArtifactEntry(model, type, artifactUUID);
            ArtifactDetails details = new ArtifactDetails();
            details.setUuid(entry.getId().toString());
            details.setName(entry.getTitle());
            details.setDescription(entry.getSummary());
            String author = null;
            if (entry.getAuthors() != null && entry.getAuthors().size() > 0) {
                author = ((Person)entry.getAuthors().get(0)).getName();
            }
            details.setCreatedBy(author);
            details.setCreatedOn(entry.getPublished());
            details.setUpdatedOn(entry.getUpdated());
            BaseArtifactType artifact = SrampClientUtils.unwrapSrampArtifact((String)type, (Entry)entry);
            details.getClassifiedBy().addAll(artifact.getClassifiedBy());
            details.setUpdatedBy(artifact.getLastModifiedBy());
            return details;
        }
        catch (SrampServerException e) {
            throw ExceptionUtils.createRemoteException(e);
        }
        catch (Throwable t) {
            throw ExceptionUtils.createRemoteException(t);
        }
    }
}

