/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.server.rsvcs;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.ArrayList;
import java.util.List;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.ui.server.api.SrampAtomApiClient;
import org.overlord.sramp.ui.server.util.ExceptionUtils;
import org.overlord.sramp.ui.shared.beans.ArtifactSummary;
import org.overlord.sramp.ui.shared.beans.PageInfo;
import org.overlord.sramp.ui.shared.rsvcs.IQueryRemoteService;
import org.overlord.sramp.ui.shared.rsvcs.RemoteServiceException;
import org.overlord.sramp.ui.shared.types.ArtifactTypeFilter;

public class QueryRemoteService
extends RemoteServiceServlet
implements IQueryRemoteService {
    private static final long serialVersionUID = QueryRemoteService.class.hashCode();

    public List<ArtifactSummary> findArtifacts(PageInfo page, ArtifactTypeFilter filter, String nameFilter) throws RemoteServiceException {
        try {
            int startIndex = page.getPage() * page.getPageSize();
            String query = filter.getQueryBase();
            if (nameFilter != null) {
                String criteria = nameFilter.replace("*", ".*").replace("'", "''");
                query = query + "[fn:matches(@name, '" + criteria + "')]";
            }
            QueryResultSet rset = SrampAtomApiClient.getInstance().query(query, startIndex, page.getPageSize(), page.getOrderBy(), page.isAscending());
            ArrayList<ArtifactSummary> rval = new ArrayList<ArtifactSummary>();
            for (org.overlord.sramp.client.query.ArtifactSummary entry : rset) {
                ArtifactSummary arty = new ArtifactSummary();
                ArtifactType artifactType = entry.getType();
                arty.setModel(artifactType.getArtifactType().getModel());
                arty.setType(artifactType.getType());
                arty.setUuid(entry.getUuid());
                arty.setName(entry.getName());
                arty.setDescription(entry.getDescription());
                arty.setCreatedBy(entry.getCreatedBy());
                arty.setCreatedOn(entry.getCreatedTimestamp());
                arty.setUpdatedOn(entry.getLastModifiedTimestamp());
                arty.setDerived(artifactType.getArtifactType().isDerived());
                rval.add(arty);
            }
            return rval;
        }
        catch (Throwable t) {
            throw ExceptionUtils.createRemoteException((Throwable)t);
        }
    }
}

