/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.shared.beans;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class Version
implements Serializable {
    private static final long serialVersionUID = -3356069827138368989L;
    private String version;
    private Date date;

    public static final Version getCurrentVersion() {
        Version version = new Version();
        InputStream resourceAsStream = null;
        try {
            resourceAsStream = Version.class.getResourceAsStream("/META-INF/config/" + Version.class.getName() + ".properties");
            Properties props = new Properties();
            props.load(resourceAsStream);
            String srampuiVersion = props.getProperty("srampui.version");
            Date buildDate = Version.parseBuildDate((String)props.getProperty("build.date"));
            version.setVersion(srampuiVersion);
            version.setDate(buildDate);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resourceAsStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)resourceAsStream);
        return version;
    }

    private static Date parseBuildDate(String dateString) {
        if (dateString.equals("${maven.build.timestamp}")) {
            return new Date();
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return format.parse(dateString);
        }
        catch (ParseException e) {
            format = new SimpleDateFormat("yyyyMMdd-HHmm");
            try {
                return format.parse(dateString);
            }
            catch (ParseException parseException) {
                return new Date();
            }
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
}

