/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.overlord.sramp.atom.visitors.ArtifactContentTypeVisitor;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.visitors.ArtifactVisitor;
import org.overlord.sramp.common.visitors.ArtifactVisitorHelper;
import org.overlord.sramp.ui.server.api.SrampAtomApiClient;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.DocumentArtifactType;

public class ArtifactDownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = ArtifactDownloadServlet.class.hashCode();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpServletResponse httpResponse = resp;
        InputStream artifactContent = null;
        try {
            DocumentArtifactType d;
            long size;
            SrampAtomApiClient client = SrampAtomApiClient.getInstance();
            String uuid = req.getParameter("uuid");
            String type = req.getParameter("type");
            ArtifactType artyType = ArtifactType.valueOf((String)type);
            BaseArtifactType artifact = client.getArtifactMetaData(artyType, uuid);
            String artifactName = artifact.getName();
            String disposition = String.format("attachment; filename=\"%1$s\"", artifactName);
            httpResponse.setHeader("Content-Disposition", disposition);
            ArtifactContentTypeVisitor ctVizzy = new ArtifactContentTypeVisitor();
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)ctVizzy, (BaseArtifactType)artifact);
            String contentType = ctVizzy.getContentType().toString();
            httpResponse.setHeader("Content-Type", contentType);
            if (artifact instanceof DocumentArtifactType && (size = (d = (DocumentArtifactType)artifact).getContentSize().longValue()) != -1L) {
                httpResponse.setHeader("Content-Size", String.valueOf(size));
            }
            Date now = new Date();
            httpResponse.setDateHeader("Date", now.getTime());
            httpResponse.setDateHeader("Expires", now.getTime() - 86400000L);
            httpResponse.setHeader("Pragma", "no-cache");
            httpResponse.setHeader("Cache-control", "no-cache, no-store, must-revalidate");
            artifactContent = client.getArtifactContent(artyType, uuid);
            IOUtils.copy((InputStream)artifactContent, (OutputStream)httpResponse.getOutputStream());
        }
        catch (Exception e) {
            try {
                throw new ServletException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(artifactContent);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)artifactContent);
    }
}

