/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.maven.plugin.jbossmodules;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.JarIndexer;
import org.ovirt.maven.plugin.jbossmodules.Module;

@Mojo(name="attach-modules", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE)
public class AttachModulesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="moduleName", required=false)
    private String moduleName;
    @Parameter(property="moduleSlot", required=false, defaultValue="main")
    private String moduleSlot;
    @Parameter(property="modules")
    private List<Module> modules;
    @Parameter(property="generateIndex", defaultValue="true")
    private boolean generateIndex;
    @Parameter(property="category", defaultValue="")
    private String category;
    private File modulesDir;

    public void execute() throws MojoExecutionException {
        String sourcePath = "src" + File.separator + "main" + File.separator + "modules";
        File sourceDir = new File(this.project.getBasedir(), sourcePath);
        if (!sourceDir.exists()) {
            this.getLog().info((CharSequence)("The modules source directory \"" + sourceDir.getAbsolutePath() + "\" doesn't exist, no modules " + "artifacts will be attached."));
            return;
        }
        if (this.modules == null) {
            this.modules = new ArrayList<Module>(1);
        }
        if (this.modules.isEmpty()) {
            Module module = new Module();
            module.setArtifactId(this.project.getArtifactId());
            module.setGroupId(this.project.getGroupId());
            this.modules.add(module);
        }
        File targetDir = new File(this.project.getBuild().getDirectory());
        this.modulesDir = new File(targetDir, "modules");
        this.getLog().info((CharSequence)("Creating modules directory \"" + this.modulesDir + "\""));
        if (!this.modulesDir.exists() && !this.modulesDir.mkdirs()) {
            throw new MojoExecutionException("Can't create target modules directory \"" + this.modulesDir.getAbsolutePath() + "\"");
        }
        this.getLog().info((CharSequence)("Copying module resources to \"" + this.modulesDir + "\""));
        if (sourceDir.exists()) {
            try {
                FileUtils.copyDirectoryStructure((File)sourceDir, (File)this.modulesDir);
            }
            catch (IOException exception) {
                throw new MojoExecutionException("Can't copy source modules directory \"" + sourceDir.getAbsolutePath() + "\" to target modules " + "directory \"" + this.modulesDir.getAbsolutePath() + "\"", (Exception)exception);
            }
        }
        for (Module module : this.modules) {
            this.createModule(module);
        }
        File modulesArchive = new File(targetDir, this.makeArchiveName());
        ZipArchiver modulesArchiver = new ZipArchiver();
        modulesArchiver.setDestFile(modulesArchive);
        modulesArchiver.addDirectory(this.modulesDir);
        this.getLog().info((CharSequence)("Creating module archive \"" + modulesArchive + "\""));
        try {
            modulesArchiver.createArchive();
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Can't generate modules archive \"" + modulesArchive.getAbsolutePath() + "\"", exception);
        }
        this.getLog().info((CharSequence)("Attaching modules artifact \"" + modulesArchive + "\""));
        this.projectHelper.attachArtifact(this.project, "zip", this.makeClassifier(), modulesArchive);
    }

    private String makeArchiveName() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.project.getBuild().getFinalName());
        buffer.append("-");
        if (this.category != null && !this.category.isEmpty()) {
            buffer.append(this.category);
            buffer.append("-");
        }
        buffer.append("modules.zip");
        return buffer.toString();
    }

    private String makeClassifier() {
        StringBuilder buffer = new StringBuilder();
        if (this.category != null && !this.category.isEmpty()) {
            buffer.append(this.category);
            buffer.append("-");
        }
        buffer.append("modules");
        return buffer.toString();
    }

    private void createModule(Module module) throws MojoExecutionException {
        String modulePath = module.getModuleName().replace(".", File.separator);
        String slotPath = modulePath + File.separator + module.getModuleSlot();
        File slotDir = new File(this.modulesDir, slotPath);
        this.getLog().info((CharSequence)("Creating slot directory \"" + slotDir + "\""));
        if (!slotDir.exists() && !slotDir.mkdirs()) {
            throw new MojoExecutionException("Can't create module directory \"" + slotDir.getAbsolutePath() + "\"");
        }
        Artifact matchingArtifact = null;
        if (module.matches(this.project.getArtifact())) {
            matchingArtifact = this.project.getArtifact();
        } else {
            for (Artifact currentArtifact : this.project.getDependencyArtifacts()) {
                if (!module.matches(currentArtifact)) continue;
                matchingArtifact = currentArtifact;
            }
        }
        if (matchingArtifact == null) {
            throw new MojoExecutionException("Can't find dependency matching artifact id \"" + module.getArtifactId() + "\" and group " + "id \"" + module.getGroupId() + "\"");
        }
        File artifactFrom = matchingArtifact.getFile();
        if (artifactFrom == null) {
            throw new MojoExecutionException("Can't find file for artifact id \"" + module.getArtifactId() + "\" " + "and group id \"" + module.getGroupId() + "\"");
        }
        File artifactTo = new File(slotDir, module.getResourcePath());
        this.getLog().info((CharSequence)("Copying artifact to \"" + artifactTo.getAbsolutePath() + "\""));
        try {
            FileUtils.copyFile((File)artifactFrom, (File)artifactTo);
        }
        catch (IOException exception) {
            throw new MojoExecutionException("Can't copy artifact file \"" + artifactFrom.getAbsolutePath() + "\" to slot directory \"" + slotDir.getAbsolutePath() + "\".", (Exception)exception);
        }
        if (this.generateIndex) {
            this.getLog().info((CharSequence)("Creating annotations index for \"" + artifactTo.getAbsolutePath() + "\""));
            try {
                JarIndexer.createJarIndex((File)artifactTo, (Indexer)new Indexer(), (boolean)true, (boolean)false, (boolean)false);
            }
            catch (IOException exception) {
                throw new MojoExecutionException("Can't add annotations index to \"" + artifactTo.getAbsolutePath() + "\".", (Exception)exception);
            }
        }
    }
}

