/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Map;
import org.ovirt.vdsm.jsonrpc.client.utils.JsonUtils;

public class JsonRpcEvent {
    public static final String ERROR_KEY = "communicationError";
    public static final String MESSAGE_FORMAT = "{\"jsonrpc\": \"2.0\", \"method\": \"%s\", \"params\": %s}";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private String method;
    private JsonNode params;
    private long arrivalTime;

    public JsonRpcEvent(String method, JsonNode params) {
        this.method = method;
        this.params = params;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public JsonNode getParams() {
        return this.params;
    }

    public void setParams(JsonNode node) {
        this.params = node;
    }

    public static JsonRpcEvent fromJsonNode(JsonNode node) {
        JsonNode tmp = node.get("jsonrpc");
        if (tmp == null) {
            throw new IllegalArgumentException("'jsonrpc' field missing in node");
        }
        String version = tmp.asText();
        if (version == null || !version.equals("2.0")) {
            throw new IllegalArgumentException("Only jsonrpc 2.0 is supported");
        }
        tmp = node.get("method");
        if (tmp == null) {
            throw new IllegalArgumentException("'method' field missing in node");
        }
        if (!tmp.isTextual()) {
            throw new IllegalArgumentException("'method' field is not textual");
        }
        String method = tmp.asText();
        if (method.isEmpty()) {
            throw new IllegalArgumentException("'method' field contains an empty string");
        }
        return new JsonRpcEvent(method, node.get("params"));
    }

    public static JsonRpcEvent fromMethodAndParams(String method, Map<String, Object> params) throws IOException {
        return JsonRpcEvent.fromByteArray(String.format(MESSAGE_FORMAT, method, MAPPER.writeValueAsString(params)).getBytes(JsonUtils.UTF8));
    }

    public static JsonRpcEvent fromByteArray(byte[] message) {
        try {
            return JsonRpcEvent.fromJsonNode(MAPPER.readTree(message));
        }
        catch (IOException e) {
            return null;
        }
    }

    public JsonNode toJson() {
        ObjectNode node = MAPPER.createObjectNode();
        node.put("jsonrpc", "2.0");
        if (this.getMethod() == null) {
            node.putNull("method");
        } else {
            node.put("method", this.getMethod());
        }
        if (this.getParams() == null) {
            node.putNull("params");
        } else {
            node.put("params", this.getParams());
        }
        return node;
    }

    public String toString() {
        return "<JsonRpcEvent method: " + this.getMethod() + ", params: " + this.getParams().toString() + ">";
    }

    public long getArrivalTime() {
        return this.arrivalTime;
    }

    public void setArrivalTime(long arrivalTime) {
        this.arrivalTime = arrivalTime;
    }
}

