/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Map;

public class JsonRpcRequest {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private String method;
    private JsonNode params;
    private JsonNode id;

    public JsonRpcRequest(String method, JsonNode params, JsonNode id) {
        this.method = method;
        this.params = params;
        this.id = id;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public JsonNode getParams() {
        return this.params;
    }

    public void setParams(JsonNode node) {
        this.params = node;
    }

    public JsonNode getId() {
        return this.id;
    }

    public void setId(JsonNode node) {
        this.id = node;
    }

    public String getPlainId() {
        return this.getId().textValue();
    }

    public static JsonRpcRequest fromJsonNode(JsonNode node) {
        JsonNode tmp = node.get("jsonrpc");
        if (tmp == null) {
            throw new IllegalArgumentException("'jsonrpc' field missing in node");
        }
        String version = tmp.asText();
        if (version == null || !version.equals("2.0")) {
            throw new IllegalArgumentException("Only jsonrpc 2.0 is supported");
        }
        tmp = node.get("method");
        if (tmp == null) {
            throw new IllegalArgumentException("'method' field missing in node");
        }
        if (!tmp.isTextual()) {
            throw new IllegalArgumentException("'method' field is not textual");
        }
        String method = tmp.asText();
        if (method.isEmpty()) {
            throw new IllegalArgumentException("'method' field contains an empty string");
        }
        return new JsonRpcRequest(method, node.get("params"), node.get("id"));
    }

    public static JsonRpcRequest fromByteArray(byte[] message) {
        try {
            return JsonRpcRequest.fromJsonNode(MAPPER.readTree(message));
        }
        catch (IOException e) {
            return null;
        }
    }

    public JsonNode toJson() {
        ObjectNode node = MAPPER.createObjectNode();
        node.put("jsonrpc", "2.0");
        if (this.getMethod() == null) {
            node.putNull("method");
        } else {
            node.put("method", this.getMethod());
        }
        if (this.getParams() == null) {
            node.putNull("params");
        } else {
            node.put("params", this.getParams());
        }
        if (this.getId() == null) {
            node.putNull("id");
        } else {
            node.put("id", this.getId());
        }
        return node;
    }

    public String toString() {
        Class<Map> clazz = Map.class;
        Map params = (Map)MAPPER.convertValue((Object)this.getParams(), clazz);
        if (params.containsKey("password")) {
            params.put("password", "*****");
        }
        return "<JsonRpcRequest id: " + this.getId() + ", method: " + this.getMethod() + ", params: " + params + ">";
    }
}

