/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.ovirt.vdsm.jsonrpc.client.JsonRpcResponse;

public class ResponseBuilder {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private JsonNode result;
    private JsonNode error;
    private JsonNode id;

    public ResponseBuilder(JsonNode id) {
        this.id = id;
    }

    public ResponseBuilder withResult(Map<String, Object> result) {
        this.result = OBJECT_MAPPER.valueToTree(result);
        return this;
    }

    public ResponseBuilder withResult(String result) {
        this.result = OBJECT_MAPPER.valueToTree((Object)result);
        return this;
    }

    public ResponseBuilder withResult(List<Object> result) {
        this.result = OBJECT_MAPPER.valueToTree(result);
        return this;
    }

    public ResponseBuilder withError(Map<String, Object> error) {
        this.error = OBJECT_MAPPER.valueToTree(error);
        return this;
    }

    public JsonRpcResponse build() {
        return new JsonRpcResponse(this.result, this.error, this.id);
    }
}

