/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client.events;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.ovirt.vdsm.jsonrpc.client.JsonRpcEvent;
import org.ovirt.vdsm.jsonrpc.client.events.SubscriptionHolder;
import org.ovirt.vdsm.jsonrpc.client.utils.JsonUtils;

public class SubscriptionMatcher {
    private ConcurrentMap<String, List<SubscriptionHolder>> receiver = new ConcurrentHashMap<String, List<SubscriptionHolder>>();
    private ConcurrentMap<String, List<SubscriptionHolder>> component = new ConcurrentHashMap<String, List<SubscriptionHolder>>();
    private ConcurrentMap<String, List<SubscriptionHolder>> operation = new ConcurrentHashMap<String, List<SubscriptionHolder>>();
    private ConcurrentMap<String, SubscriptionHolder> unique_id = new ConcurrentHashMap<String, SubscriptionHolder>();
    private List<SubscriptionHolder> allSubscriptions = new CopyOnWriteArrayList<SubscriptionHolder>();

    public void add(SubscriptionHolder holder) {
        if ("*|*|*|*".equals(holder.getId())) {
            throw new IllegalArgumentException("Can't subscribe to all events");
        }
        String[] ids = JsonUtils.parse(holder.getId());
        try {
            String uid = ids[3];
            if (!"*".equals(uid)) {
                this.validateKey(uid);
                this.unique_id.put(uid, holder);
            } else {
                String rKey;
                String compKey;
                String opKey = ids[2];
                if (!"*".equals(opKey)) {
                    this.update(this.operation, opKey, holder);
                }
                if (!"*".equals(compKey = ids[1])) {
                    this.update(this.component, compKey, holder);
                }
                if (!"*".equals(rKey = ids[0])) {
                    this.update(this.receiver, rKey, holder);
                }
            }
            this.allSubscriptions.add(holder);
        }
        catch (IllegalArgumentException e) {
            this.remove(holder);
            throw e;
        }
    }

    private void update(ConcurrentMap<String, List<SubscriptionHolder>> map, String key, SubscriptionHolder holder) {
        this.validateKey(key);
        List<SubscriptionHolder> holders = new CopyOnWriteArrayList<SubscriptionHolder>();
        holders.add(holder);
        holders = map.putIfAbsent(key, holders);
        if (holders != null) {
            holders.add(holder);
        }
    }

    private void validateKey(String key) {
        if (JsonUtils.isEmpty(key)) {
            throw new IllegalArgumentException("Wrong id format");
        }
    }

    public Set<SubscriptionHolder> match(JsonRpcEvent event) {
        String[] ids = JsonUtils.parse(event.getMethod());
        HashSet<SubscriptionHolder> subscriptions = new HashSet<SubscriptionHolder>();
        SubscriptionHolder holder = (SubscriptionHolder)this.unique_id.get(ids[3]);
        if (holder != null) {
            subscriptions.add(holder);
        }
        Predicate equalsPredicate = (one, two) -> one == two;
        this.addHolders(subscriptions, this.operation, 2, ids, equalsPredicate);
        this.addHolders(subscriptions, this.component, 1, ids, equalsPredicate);
        this.addHolders(subscriptions, this.receiver, 0, ids, equalsPredicate);
        return subscriptions;
    }

    private void addHolders(Set<SubscriptionHolder> holders, ConcurrentMap<String, List<SubscriptionHolder>> map, int key, String[] ids, Predicate predicate) {
        List values = (List)map.get(ids[key]);
        if (values == null) {
            return;
        }
        values.stream().filter(value -> {
            List<String> fids = value.getFilteredId();
            int size = fids.size();
            fids.retainAll(Arrays.asList(ids));
            int count = Collections.frequency(Arrays.asList(ids), "*");
            return predicate.apply(size, fids.size()) || count == 3;
        }).forEach(holders::add);
    }

    public void remove(SubscriptionHolder holder) {
        String[] ids = holder.getParsedId();
        String uid = ids[3];
        this.unique_id.remove(uid);
        this.clean(this.operation, ids[2], holder);
        this.clean(this.component, ids[1], holder);
        this.clean(this.receiver, ids[0], holder);
        this.allSubscriptions.remove(holder);
    }

    private void clean(ConcurrentMap<String, List<SubscriptionHolder>> map, String key, SubscriptionHolder holder) {
        List holders = (List)map.get(key);
        if (holders != null) {
            if (holders.size() > 1) {
                holders.remove(holder);
            } else {
                map.remove(key);
            }
        }
    }

    public List<SubscriptionHolder> getAllSubscriptions() {
        return this.allSubscriptions;
    }

    private static interface Predicate {
        public boolean apply(int var1, int var2);
    }
}

