/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client.internal;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.ovirt.vdsm.jsonrpc.client.BrokerCommandCallback;
import org.ovirt.vdsm.jsonrpc.client.JsonRpcRequest;
import org.ovirt.vdsm.jsonrpc.client.JsonRpcResponse;
import org.ovirt.vdsm.jsonrpc.client.internal.JsonRpcCall;

public class Call
implements Future<JsonRpcResponse>,
JsonRpcCall {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final JsonNode id;
    private JsonRpcResponse response;
    private BrokerCommandCallback callback;

    public Call(JsonRpcRequest req) {
        this.id = req.getId();
    }

    public Call(JsonRpcRequest req, BrokerCommandCallback callback) {
        this(req);
        this.callback = callback;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public void addResponse(JsonRpcResponse response) {
        if (this.response != null) {
            return;
        }
        this.response = response;
        this.latch.countDown();
    }

    public JsonNode getId() {
        return this.id;
    }

    @Override
    public JsonRpcResponse get() throws InterruptedException {
        this.latch.await();
        return this.response;
    }

    @Override
    public JsonRpcResponse get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.latch.await(timeout, unit)) {
            throw new TimeoutException();
        }
        return this.response;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public BrokerCommandCallback getCallback() {
        return this.callback;
    }
}

