/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ovirt.vdsm.jsonrpc.client.JsonRpcRequest;
import org.ovirt.vdsm.jsonrpc.client.JsonRpcResponse;
import org.ovirt.vdsm.jsonrpc.client.RequestAlreadySentException;
import org.ovirt.vdsm.jsonrpc.client.internal.JsonRpcCall;
import org.ovirt.vdsm.jsonrpc.client.utils.JsonUtils;
import org.ovirt.vdsm.jsonrpc.client.utils.LockWrapper;
import org.ovirt.vdsm.jsonrpc.client.utils.ResponseTracking;
import org.ovirt.vdsm.jsonrpc.client.utils.retry.RetryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseTracker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ResponseTracker.class);
    private static final int TRACKING_TIMEOUT = 500;
    private final AtomicBoolean isTracking = new AtomicBoolean(true);
    private final ConcurrentMap<JsonNode, JsonRpcCall> runningCalls = new ConcurrentHashMap<JsonNode, JsonRpcCall>();
    private final ConcurrentMap<JsonNode, ResponseTracking> map = new ConcurrentHashMap<JsonNode, ResponseTracking>();
    private final ConcurrentMap<String, List<JsonNode>> hostToId = new ConcurrentHashMap<String, List<JsonNode>>();
    private final Queue<JsonNode> queue = new ConcurrentLinkedQueue<JsonNode>();
    private final Lock lock = new ReentrantLock();
    private ScheduledExecutorService executorService;

    private void removeRequestFromTracking(JsonNode id) {
        try (LockWrapper ignored = new LockWrapper(this.lock);){
            this.queue.remove(id);
            ResponseTracking tracking = (ResponseTracking)this.map.remove(id);
            if (tracking != null && tracking.getClient() != null) {
                this.hostToId.computeIfPresent(tracking.getClient().getClientId(), (clientId, nodes) -> {
                    nodes.remove(id);
                    return nodes;
                });
            }
        }
    }

    public void registerCall(JsonRpcRequest req, JsonRpcCall call) {
        if (this.runningCalls.putIfAbsent(req.getId(), call) != null) {
            throw new RequestAlreadySentException();
        }
    }

    public JsonRpcCall removeCall(JsonNode id) {
        this.removeRequestFromTracking(id);
        return (JsonRpcCall)this.runningCalls.remove(id);
    }

    public void registerTrackingRequest(JsonRpcRequest req, ResponseTracking tracking) {
        JsonNode id = req.getId();
        List<JsonNode> nodes = new CopyOnWriteArrayList<JsonNode>();
        try (LockWrapper ignored = new LockWrapper(this.lock);){
            this.map.put(id, tracking);
            if (!this.queue.contains(id)) {
                this.queue.add(id);
            }
            nodes.add(id);
            nodes = this.hostToId.putIfAbsent(tracking.getClient().getClientId(), nodes);
            if (nodes != null && !nodes.contains(id)) {
                nodes.add(id);
            }
        }
    }

    @Override
    public void run() {
        try {
            while (this.isTracking.get()) {
                TimeUnit.MILLISECONDS.sleep(500L);
                this.loop();
            }
        }
        catch (InterruptedException e) {
            log.warn("Tracker thread interrupted");
        }
    }

    protected void loop() {
        for (JsonNode id : this.queue) {
            if (this.runningCalls.computeIfAbsent(id, _id -> {
                this.removeRequestFromTracking(id);
                return null;
            }) == null) continue;
            ResponseTracking tracking = (ResponseTracking)this.map.get(id);
            if (System.currentTimeMillis() >= tracking.getTimeout()) {
                RetryContext context = tracking.getContext();
                context.decreaseAttempts();
                if (context.getNumberOfAttempts() <= 0) {
                    this.handleFailure(tracking, id, "Too many attempts");
                    continue;
                }
                byte[] message = JsonUtils.jsonToByteArray(tracking.getRequest().toJson());
                if (log.isDebugEnabled()) {
                    log.debug("Message to be sent {}", (Object)new String(message, StandardCharsets.UTF_8));
                }
                tracking.getClient().sendMessage(message);
                tracking.setTimeout(JsonUtils.getTimeout(context.getTimeout(), context.getTimeUnit()));
                continue;
            }
            log.debug("Tracking timeout detected for request id {} ", (Object)id.asText());
        }
    }

    public void close() {
        this.isTracking.set(false);
    }

    private void handleFailure(ResponseTracking tracking, JsonNode id, String failureDetails) {
        log.debug("Failure for request id {}. Details: {}", (Object)id.asText(), (Object)failureDetails);
        this.remove(tracking, id, JsonUtils.buildFailedResponse(tracking.getRequest()));
        if (tracking.isResetConnection() && !tracking.getClient().isOpen()) {
            tracking.getClient().disconnect("Vds timeout occurred");
        }
    }

    public void setExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    private void remove(ResponseTracking tracking, JsonNode id, JsonRpcResponse response) {
        try (LockWrapper ignored = new LockWrapper(this.lock);){
            JsonRpcCall call = (JsonRpcCall)this.runningCalls.remove(id);
            boolean callbackNotified = false;
            if (call != null) {
                call.addResponse(response);
                if (call.getCallback() != null && this.executorService != null) {
                    callbackNotified = true;
                    this.executorService.schedule(() -> call.getCallback().onFailure(JsonUtils.mapValues(response.getError())), 0L, TimeUnit.SECONDS);
                }
            }
            this.removeRequestFromTracking(id);
            if (!callbackNotified && tracking != null && tracking.getClient() != null) {
                tracking.getCall().addResponse(response);
                if (tracking.getCall().getCallback() != null && this.executorService != null) {
                    this.executorService.schedule(() -> tracking.getCall().getCallback().onFailure(JsonUtils.mapValues(response.getError())), 0L, TimeUnit.SECONDS);
                }
            }
        }
    }

    public void processIssue(JsonRpcResponse response) {
        JsonNode error = response.getError();
        Map<String, Object> map = JsonUtils.mapValues(error);
        String code = (String)map.get("code");
        String message = (String)map.get("message");
        JsonRpcResponse errorResponse = JsonUtils.buildErrorResponse(null, 5022, message);
        try (LockWrapper ignored = new LockWrapper(this.lock);){
            if ("Client close".equals(message)) {
                this.removeNodes((List)this.hostToId.get(code), errorResponse);
            } else {
                String hostname = code.substring(0, code.indexOf(":"));
                this.hostToId.keySet().stream().filter(key -> key.startsWith(hostname)).forEach(key -> this.removeNodes((List)this.hostToId.get(key), errorResponse));
            }
        }
    }

    private void removeNodes(List<JsonNode> nodes, JsonRpcResponse errorResponse) {
        nodes.stream().filter(id -> !(id instanceof NullNode)).forEach(id -> this.remove((ResponseTracking)this.map.get(id), (JsonNode)id, errorResponse));
    }

    protected Map<String, List<JsonNode>> getHostMap() {
        return this.hostToId;
    }
}

