/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client.reactors;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.ovirt.vdsm.jsonrpc.client.ClientConnectionException;
import org.ovirt.vdsm.jsonrpc.client.reactors.ReactorClient;
import org.ovirt.vdsm.jsonrpc.client.reactors.ReactorListener;
import org.ovirt.vdsm.jsonrpc.client.utils.JsonUtils;
import org.ovirt.vdsm.jsonrpc.client.utils.ReactorScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Reactor
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(Reactor.class);
    private static final int TIMEOUT = 1000;
    private final AbstractSelector selector = SelectorProvider.provider().openSelector();
    private final ReactorScheduler scheduler = new ReactorScheduler();
    private boolean isRunning = false;

    public Reactor() throws IOException {
        this.setName(this.getReactorName());
        this.setDaemon(true);
        this.start();
    }

    private void select() {
        try {
            this.selector.select(1000L);
        }
        catch (IOException e) {
            JsonUtils.logException(LOG, "IOException occurred", e);
        }
    }

    @Override
    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            this.select();
            try {
                this.scheduler.performPendingOperations();
            }
            catch (Exception e) {
                JsonUtils.logException(LOG, "Exception occurred during running scheduled task", e);
            }
            this.processChannels();
        }
    }

    private void processChannels() {
        this.selector.selectedKeys().stream().filter(SelectionKey::isValid).filter(key -> !key.isAcceptable() || ((ReactorListener)key.attachment()).accept() != null).forEach(key -> {
            if (key.isReadable() || key.isWritable()) {
                ReactorClient client = (ReactorClient)key.attachment();
                try {
                    client.process();
                }
                catch (IOException | ClientConnectionException ex) {
                    this.handleException(ex, client, (SelectionKey)key, "Unable to process messages ");
                }
                catch (Throwable e) {
                    this.handleException(e, client, (SelectionKey)key, "Internal server error ");
                }
            }
            if (!key.channel().isOpen()) {
                key.cancel();
            }
        });
        this.checkActions(this.selector.keys());
    }

    private void checkActions(Set<SelectionKey> keys) {
        keys.stream().filter(key -> ReactorClient.class.isInstance(key.attachment())).forEach(key -> {
            ReactorClient client = (ReactorClient)key.attachment();
            try {
                client.performAction();
            }
            catch (IOException e) {
                this.handleException(e, client, (SelectionKey)key, "Unable to process messages ");
            }
        });
    }

    private void handleException(Throwable t, ReactorClient client, SelectionKey key, String message) {
        JsonUtils.logException(LOG, message + t.getMessage(), t);
        client.disconnect(t.getMessage() != null ? t.getMessage() : message);
        key.cancel();
    }

    public void queueFuture(Future<?> f) {
        this.scheduler.queueFuture(f);
        this.wakeup();
    }

    public void wakeup() {
        this.selector.wakeup();
    }

    public Future<ReactorListener> createListener(String hostname, int port, ReactorListener.EventListener owner) {
        Reactor reactor = this;
        FutureTask<ReactorListener> task = new FutureTask<ReactorListener>(() -> {
            InetAddress address = InetAddress.getByName(hostname);
            return new ReactorListener(reactor, new InetSocketAddress(address, port), this.selector, owner);
        });
        this.queueFuture(task);
        return task;
    }

    public ReactorClient createClient(String hostname, int port) throws ClientConnectionException {
        return this.createClient(this, this.selector, hostname, port);
    }

    public void close() {
        this.isRunning = false;
        this.wakeup();
    }

    protected abstract ReactorClient createClient(Reactor var1, Selector var2, String var3, int var4);

    protected abstract ReactorClient createConnectedClient(Reactor var1, Selector var2, String var3, int var4, SocketChannel var5) throws ClientConnectionException;

    protected abstract String getReactorName();
}

