/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client.reactors;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.rmi.ConnectException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.ovirt.vdsm.jsonrpc.client.ClientConnectionException;
import org.ovirt.vdsm.jsonrpc.client.internal.ClientPolicy;
import org.ovirt.vdsm.jsonrpc.client.reactors.Reactor;
import org.ovirt.vdsm.jsonrpc.client.utils.JsonUtils;
import org.ovirt.vdsm.jsonrpc.client.utils.LockWrapper;
import org.ovirt.vdsm.jsonrpc.client.utils.OneTimeCallback;
import org.ovirt.vdsm.jsonrpc.client.utils.retry.DefaultConnectionRetryPolicy;
import org.ovirt.vdsm.jsonrpc.client.utils.retry.Retryable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReactorClient {
    public static final List<Certificate> PEER_CERTIFICATE_EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    public static final String CLIENT_CLOSED = "Client close";
    public static final int BUFFER_SIZE = 1024;
    private static final int LIMIT = 20000;
    private static final Logger log = LoggerFactory.getLogger(ReactorClient.class);
    private final String hostname;
    private final int port;
    private final Lock lock;
    private final AtomicLong lastIncomingHeartbeat = new AtomicLong(0L);
    private final AtomicLong lastOutgoingHeartbeat = new AtomicLong(0L);
    private final AtomicBoolean closing = new AtomicBoolean();
    protected final AtomicBoolean half = new AtomicBoolean(true);
    protected volatile ClientPolicy policy = new DefaultConnectionRetryPolicy();
    protected final List<MessageListener> eventListeners;
    protected final Reactor reactor;
    protected final Deque<ByteBuffer> outbox;
    protected SelectionKey key;
    protected ByteBuffer ibuff = null;
    protected SocketChannel channel;

    public ReactorClient(Reactor reactor, String hostname, int port) {
        this.reactor = reactor;
        this.hostname = hostname;
        this.port = port;
        this.eventListeners = new CopyOnWriteArrayList<MessageListener>();
        this.lock = new ReentrantLock();
        this.outbox = new ConcurrentLinkedDeque<ByteBuffer>();
        this.closing.set(false);
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getClientId() {
        String connectionHash = this.channel == null ? "" : Integer.toString(this.channel.hashCode());
        return this.hostname + ":" + connectionHash;
    }

    public void setClientPolicy(ClientPolicy policy) {
        this.validate(policy);
        this.policy = policy;
    }

    public ClientPolicy getRetryPolicy() {
        return this.policy;
    }

    public void connect() throws ClientConnectionException {
        if (this.isOpen()) {
            return;
        }
        try (LockWrapper ignored = new LockWrapper(this.lock);){
            if (this.isOpen() && this.isInInit()) {
                this.getPostConnectCallback().await(this.policy.getRetryTimeOut(), this.policy.getTimeUnit());
            }
            if (this.isOpen()) {
                return;
            }
            FutureTask<SocketChannel> task = this.scheduleTask(new Retryable<SocketChannel>(() -> {
                InetAddress address = InetAddress.getByName(this.hostname);
                log.info("Connecting to {}", (Object)address);
                InetSocketAddress addr = new InetSocketAddress(address, this.port);
                SocketChannel socketChannel = SocketChannel.open();
                socketChannel.configureBlocking(false);
                socketChannel.connect(addr);
                log.info("Connected to {}:{}", (Object)address, (Object)this.port);
                return socketChannel;
            }, this.policy));
            this.channel = task.get();
            long timeout = JsonUtils.getTimeout(this.policy.getRetryTimeOut(), this.policy.getTimeUnit());
            while (!this.channel.finishConnect()) {
                FutureTask<SocketChannel> connectTask = this.scheduleTask(new Retryable<SocketChannel>(() -> {
                    if (this.now() >= timeout) {
                        throw new ConnectException("Connection timeout");
                    }
                    return null;
                }, this.policy));
                connectTask.get();
            }
            this.updateLastIncomingHeartbeat();
            this.updateLastOutgoingHeartbeat();
            if (!this.isOpen()) {
                throw new ClientConnectionException("Connection failed");
            }
            this.closing.set(false);
            this.clean();
            this.postConnect(this.getPostConnectCallback());
        }
        catch (InterruptedException | ExecutionException e) {
            JsonUtils.logException(log, "Exception during connection", e);
            String message = "Connection issue " + ExceptionUtils.getRootCause((Throwable)e).getMessage();
            this.scheduleClose(message);
            throw new ClientConnectionException(e);
        }
        catch (IOException e) {
            this.closeChannel();
            throw new ClientConnectionException("Connection failed", e);
        }
    }

    public SelectionKey getSelectionKey() {
        return this.key;
    }

    public void addEventListener(MessageListener el) {
        this.eventListeners.add(el);
    }

    public void removeEventListener(MessageListener el) {
        this.eventListeners.remove(el);
    }

    protected void emitOnMessageReceived(byte[] message) {
        for (MessageListener el : this.eventListeners) {
            el.onMessageReceived(message);
        }
    }

    public final void disconnect(String message) {
        this.closing.set(true);
        this.clean();
        byte[] response = this.buildNetworkResponse(message);
        this.postDisconnect();
        this.closeChannel();
        this.emitOnMessageReceived(response);
    }

    public Future<Void> close() {
        return this.scheduleClose(CLIENT_CLOSED);
    }

    private Future<Void> scheduleClose(String message) {
        this.closing.set(true);
        this.clean();
        return this.scheduleTask(() -> {
            this.disconnect(message);
            return null;
        });
    }

    protected <T> FutureTask<T> scheduleTask(Callable<T> callable) {
        FutureTask<T> task = new FutureTask<T>(callable);
        this.reactor.queueFuture(task);
        return task;
    }

    public void process() throws IOException, ClientConnectionException {
        if (this.closing.get()) {
            return;
        }
        this.processIncoming();
        if (this.closing.get()) {
            return;
        }
        this.processHeartbeat();
        if (this.closing.get()) {
            return;
        }
        this.processOutgoing();
    }

    protected abstract void processIncoming() throws IOException, ClientConnectionException;

    private void processHeartbeat() {
        int incoming = this.policy.getIncomingHeartbeat() / 2;
        if (incoming < 20000) {
            incoming = 20000;
        }
        if (!this.isInInit() && this.getHeartbeatTime() > (long)incoming && this.half.compareAndSet(true, false)) {
            log.info("No interaction with host '{}' for {} ms.", (Object)this.getHostname(), (Object)incoming);
        }
        if (!this.isInInit() && this.policy.isIncomingHeartbeat() && this.isIncomingHeartbeatExceeded()) {
            String msg = String.format("Connection timeout for host '%s', last response arrived %s ms ago.", this.getHostname(), this.getHeartbeatTime());
            log.error(msg);
            this.disconnect(msg);
        }
    }

    private long getHeartbeatTime() {
        return this.now() - this.lastIncomingHeartbeat.get();
    }

    private boolean isIncomingHeartbeatExceeded() {
        return this.lastIncomingHeartbeat.get() + (long)this.policy.getIncomingHeartbeat() < this.now();
    }

    protected void updateLastIncomingHeartbeat() {
        this.half.set(true);
        this.lastIncomingHeartbeat.set(this.now());
    }

    protected void updateLastOutgoingHeartbeat() {
        this.lastOutgoingHeartbeat.set(this.now());
    }

    protected void processOutgoing() throws IOException {
        ByteBuffer buff = this.outbox.peekLast();
        if (buff == null) {
            return;
        }
        this.write(buff);
        if (!buff.hasRemaining()) {
            this.outbox.removeLast();
        }
        this.updateLastOutgoingHeartbeat();
        this.updateInterestedOps();
    }

    protected void closeChannel() {
        this.closing.set(true);
        this.clean();
        Callable<Void> callable = new Callable<Void>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Void call() {
                if (ReactorClient.this.lock.tryLock()) {
                    try {
                        if (ReactorClient.this.channel == null) return null;
                        ReactorClient.this.channel.close();
                        return null;
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                    finally {
                        ReactorClient.this.channel = null;
                        ReactorClient.this.lock.unlock();
                    }
                } else {
                    ReactorClient.this.scheduleTask(this);
                }
                return null;
            }
        };
        try {
            callable.call();
        }
        catch (Exception e) {
            log.warn("Closing channel failed", (Throwable)e);
        }
    }

    public boolean isOpen() {
        return this.channel != null && this.channel.isOpen();
    }

    public int getConnectionId() {
        return Objects.hashCode(this.channel);
    }

    public void performAction() throws IOException {
        if (!this.isInInit() && this.policy.isOutgoingHeartbeat() && this.isOutgoingHeartbeatExceeded()) {
            this.sendHeartbeat();
            this.processOutgoing();
        }
    }

    private boolean isOutgoingHeartbeatExceeded() {
        return this.lastOutgoingHeartbeat.get() + (long)this.policy.getOutgoingHeartbeat() < this.now();
    }

    public long now() {
        return System.currentTimeMillis();
    }

    public abstract void sendMessage(byte[] var1);

    protected abstract int read(ByteBuffer var1) throws IOException;

    protected abstract void write(ByteBuffer var1) throws IOException;

    protected abstract void postConnect(OneTimeCallback var1) throws ClientConnectionException;

    public abstract void updateInterestedOps();

    protected abstract OneTimeCallback getPostConnectCallback();

    public abstract void postDisconnect();

    public abstract boolean isInInit();

    protected abstract byte[] buildNetworkResponse(String var1);

    protected abstract void sendHeartbeat();

    public abstract void validate(ClientPolicy var1);

    protected abstract void clean();

    public List<Certificate> getPeerCertificates() throws ClientConnectionException {
        return PEER_CERTIFICATE_EMPTY_LIST;
    }

    public static interface MessageListener {
        public void onMessageReceived(byte[] var1);
    }
}

