/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client.reactors;

import java.io.IOException;
import java.security.GeneralSecurityException;
import org.ovirt.vdsm.jsonrpc.client.ClientConnectionException;
import org.ovirt.vdsm.jsonrpc.client.internal.ResponseWorker;
import org.ovirt.vdsm.jsonrpc.client.reactors.ManagerProvider;
import org.ovirt.vdsm.jsonrpc.client.reactors.Reactor;
import org.ovirt.vdsm.jsonrpc.client.reactors.ReactorType;
import org.ovirt.vdsm.jsonrpc.client.reactors.stomp.SSLStompReactor;
import org.ovirt.vdsm.jsonrpc.client.reactors.stomp.StompReactor;

public class ReactorFactory {
    private static final int EVENT_TIMEOUT_IN_HOURS = 3;
    private static volatile StompReactor stompReactor;
    private static volatile SSLStompReactor sslStompReactor;
    private static volatile ResponseWorker worker;

    public static Reactor getReactor(ManagerProvider provider, ReactorType type) throws ClientConnectionException {
        if (ReactorType.STOMP.equals((Object)type)) {
            return ReactorFactory.getStompReactor(provider);
        }
        throw new ClientConnectionException("Unrecognized reactor type");
    }

    public static ResponseWorker getWorker(int parallelism) {
        return ReactorFactory.getWorker(parallelism, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseWorker getWorker(int parallelism, int eventTimeoutInHours) {
        if (worker != null) {
            return worker;
        }
        Class<ReactorFactory> clazz = ReactorFactory.class;
        synchronized (ReactorFactory.class) {
            if (worker != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return worker;
            }
            worker = new ResponseWorker(parallelism, eventTimeoutInHours);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return worker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Reactor getStompReactor(ManagerProvider provider) throws ClientConnectionException {
        if (provider != null) {
            return ReactorFactory.getSslStompReactor(provider);
        }
        if (stompReactor != null) {
            return stompReactor;
        }
        Class<ReactorFactory> clazz = ReactorFactory.class;
        synchronized (ReactorFactory.class) {
            if (stompReactor != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return stompReactor;
            }
            try {
                stompReactor = new StompReactor();
            }
            catch (IOException e) {
                throw new ClientConnectionException(e);
            }
            return stompReactor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Reactor getSslStompReactor(ManagerProvider provider) throws ClientConnectionException {
        if (sslStompReactor != null) {
            return sslStompReactor;
        }
        Class<ReactorFactory> clazz = ReactorFactory.class;
        synchronized (ReactorFactory.class) {
            if (sslStompReactor != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return sslStompReactor;
            }
            try {
                sslStompReactor = new SSLStompReactor(provider.getSSLContext());
            }
            catch (IOException | GeneralSecurityException e) {
                throw new ClientConnectionException(e);
            }
            return sslStompReactor;
        }
    }
}

