/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client.reactors;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.ovirt.vdsm.jsonrpc.client.ClientConnectionException;
import org.ovirt.vdsm.jsonrpc.client.reactors.Reactor;
import org.ovirt.vdsm.jsonrpc.client.reactors.SSLEngineNioHelper;
import org.ovirt.vdsm.jsonrpc.client.reactors.stomp.StompCommonClient;
import org.ovirt.vdsm.jsonrpc.client.utils.JsonUtils;
import org.ovirt.vdsm.jsonrpc.client.utils.OneTimeCallback;
import org.ovirt.vdsm.jsonrpc.client.utils.retry.Retryable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSLClient
extends StompCommonClient {
    protected static Logger log = LoggerFactory.getLogger(SSLClient.class);
    protected final Selector selector;
    protected SSLEngineNioHelper nioEngine;
    private SSLContext sslContext;
    private boolean client;

    public SSLClient(Reactor reactor, Selector selector, String hostname, int port, SSLContext sslctx) {
        super(reactor, hostname, port);
        this.selector = selector;
        this.sslContext = sslctx;
        this.client = true;
    }

    public SSLClient(Reactor reactor, Selector selector, String hostname, int port, SSLContext sslctx, SocketChannel socketChannel) throws ClientConnectionException {
        super(reactor, hostname, port);
        this.selector = selector;
        this.sslContext = sslctx;
        this.client = false;
        this.channel = socketChannel;
        this.postConnect(null);
    }

    protected SSLEngine createSSLEngine(boolean clientMode) {
        SSLEngine engine = this.sslContext.createSSLEngine();
        engine.setUseClientMode(clientMode);
        return engine;
    }

    @Override
    public void updateInterestedOps() {
        if (this.outbox.isEmpty() && (this.nioEngine == null || !this.nioEngine.handshakeInProgress())) {
            this.getSelectionKey().interestOps(1);
        } else {
            this.getSelectionKey().interestOps(5);
        }
    }

    private Runnable pendingOperations() throws IOException, ClientConnectionException {
        if (this.nioEngine == null) {
            return null;
        }
        return this.nioEngine.process();
    }

    @Override
    protected int read(ByteBuffer buff) throws IOException {
        if (this.nioEngine != null) {
            return this.nioEngine.read(buff);
        }
        return this.channel.read(buff);
    }

    @Override
    protected void write(ByteBuffer buff) throws IOException {
        if (this.nioEngine != null) {
            this.nioEngine.write(buff);
        } else {
            this.channel.write(buff);
        }
    }

    @Override
    public void process() throws IOException, ClientConnectionException {
        Runnable op = this.pendingOperations();
        if (op != null) {
            this.key.interestOps(0);
            this.scheduleTask(() -> {
                op.run();
                this.updateInterestedOps();
                this.selector.wakeup();
                return null;
            });
        }
        if (this.isInInit()) {
            return;
        }
        super.process();
    }

    @Override
    protected void postConnect(OneTimeCallback callback) throws ClientConnectionException {
        try {
            SSLClient client = this;
            FutureTask<SelectionKey> task = this.scheduleTask(new Retryable<SelectionKey>(() -> {
                if (!this.isOpen()) {
                    throw new ClosedChannelException();
                }
                return this.channel.register(this.selector, 5, client);
            }, this.policy));
            this.key = task.get();
            SSLEngine sslEngine = this.createSSLEngine(this.client);
            this.nioEngine = new SSLEngineNioHelper(this.channel, sslEngine, callback, this);
            this.nioEngine.beginHandshake();
            this.nioEngine.verifyPeerCertificates();
        }
        catch (CertificateException certificateException) {
            JsonUtils.logException(log, "Certificate validation error", certificateException);
            throw new ClientConnectionException(certificateException);
        }
        catch (InterruptedException | ExecutionException | SSLException e) {
            JsonUtils.logException(log, "Connection issues during ssl client creation", e);
            throw new ClientConnectionException(e);
        }
        if (this.key == null) {
            throw new ClientConnectionException("Connection issue during post connect");
        }
    }

    @Override
    public void postDisconnect() {
        if (this.nioEngine != null) {
            this.nioEngine.clearBuff();
        }
        this.nioEngine = null;
    }

    @Override
    public List<Certificate> getPeerCertificates() {
        try {
            if (this.nioEngine != null && this.nioEngine.getSSLEngine() != null) {
                SSLSession sslSession = this.nioEngine.getSSLEngine().getSession();
                if (sslSession == null || !sslSession.isValid()) {
                    throw new IllegalStateException("SSL session is invalid");
                }
                return Arrays.asList(sslSession.getPeerCertificates());
            }
        }
        catch (SSLPeerUnverifiedException e) {
            JsonUtils.logException(log, "Failed to get peer certificates", e);
        }
        return null;
    }
}

