/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client.reactors.stomp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.ovirt.vdsm.jsonrpc.client.reactors.ReactorClient;
import org.ovirt.vdsm.jsonrpc.client.reactors.stomp.impl.CommandExecutor;
import org.ovirt.vdsm.jsonrpc.client.reactors.stomp.impl.Message;
import org.ovirt.vdsm.jsonrpc.client.reactors.stomp.impl.Sender;
import org.ovirt.vdsm.jsonrpc.client.reactors.stomp.impl.ServerListener;
import org.ovirt.vdsm.jsonrpc.client.utils.JsonUtils;

public class CommandFactory {
    private final Map<String, List<ServerListener>> listeners = new ConcurrentHashMap<String, List<ServerListener>>();
    private final Map<String, String> destinations = new ConcurrentHashMap<String, String>();
    private final List<ReactorClient.MessageListener> eventListeners;
    private final Sender sender;
    public Map<String, CommandExecutor> commands = new HashMap<String, CommandExecutor>(){
        {
            this.put(Message.Command.CONNECT.toString(), new CommandExecutor(){

                @Override
                public Message execute(Message message) {
                    String heartbeats = message.getHeaders().get("heart-beat");
                    Message response = new Message().connected().withHeader("session", UUID.randomUUID().toString());
                    if (heartbeats != null) {
                        response.withHeader("heart-beat", JsonUtils.swapHeartbeat(heartbeats));
                    }
                    return response;
                }
            });
            this.put(Message.Command.SUBSCRIBE.toString(), new CommandExecutor(){

                @Override
                public Message execute(Message message) {
                    Map<String, String> headers = message.getHeaders();
                    String destHeader = headers.get("destination");
                    String idHeader = headers.get("id");
                    if (JsonUtils.isEmpty(destHeader) || JsonUtils.isEmpty(idHeader)) {
                        return new Message().error().withHeader("message", "Missing required header");
                    }
                    List<ServerListener> list = CommandFactory.this.listeners.get(destHeader);
                    if (list == null) {
                        list = new CopyOnWriteArrayList<ServerListener>();
                        CommandFactory.this.listeners.put(destHeader, list);
                    }
                    list.add(new ServerListener(CommandFactory.this.sender));
                    CommandFactory.this.destinations.put(idHeader, destHeader);
                    if (!JsonUtils.isEmpty(headers.get("ack"))) {
                        return new Message().ack().withHeader("id", idHeader);
                    }
                    return null;
                }
            });
            this.put(Message.Command.SEND.toString(), new CommandExecutor(){

                @Override
                public Message execute(Message message) {
                    Map<String, String> headers = message.getHeaders();
                    String destHeader = headers.get("destination");
                    if (JsonUtils.isEmpty(destHeader)) {
                        return new Message().error().withHeader("message", "Missing required header");
                    }
                    CommandFactory.this.eventListeners.stream().forEach(el -> el.onMessageReceived(message.getContent()));
                    return null;
                }
            });
            this.put(Message.Command.UNSUBSCRIBE.toString(), new CommandExecutor(){

                @Override
                public Message execute(Message message) {
                    Map<String, String> headers = message.getHeaders();
                    String idHeader = headers.get("id");
                    if (JsonUtils.isEmpty(idHeader)) {
                        return new Message().error().withHeader("message", "Missing required header");
                    }
                    String destination = CommandFactory.this.destinations.remove(idHeader);
                    if (destination == null) {
                        return new Message().error().withHeader("message", "Subscription id not available");
                    }
                    CommandFactory.this.listeners.remove(destination);
                    if (!JsonUtils.isEmpty(headers.get("ack"))) {
                        return new Message().ack().withHeader("id", idHeader);
                    }
                    return null;
                }
            });
            this.put(Message.Command.DISCONNECT.toString(), new CommandExecutor(){

                @Override
                public Message execute(Message message) {
                    Map<String, String> headers = message.getHeaders();
                    String receipt = headers.get("receipt");
                    if (JsonUtils.isEmpty(receipt)) {
                        return new Message().error().withHeader("message", "Missing required header");
                    }
                    return new Message().receipt().withHeaders(headers);
                }
            });
        }
    };

    public CommandFactory(Sender sender, List<ReactorClient.MessageListener> eventListeners) {
        this.sender = sender;
        this.eventListeners = eventListeners;
    }

    public CommandExecutor getCommandExecutor(String command) {
        return this.commands.get(command);
    }
}

