/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client.reactors.stomp;

import java.nio.channels.Selector;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import javax.net.ssl.SSLContext;
import org.ovirt.vdsm.jsonrpc.client.ClientConnectionException;
import org.ovirt.vdsm.jsonrpc.client.reactors.Reactor;
import org.ovirt.vdsm.jsonrpc.client.reactors.SSLClient;
import org.ovirt.vdsm.jsonrpc.client.reactors.stomp.impl.Message;
import org.ovirt.vdsm.jsonrpc.client.utils.JsonUtils;
import org.ovirt.vdsm.jsonrpc.client.utils.OneTimeCallback;
import org.ovirt.vdsm.jsonrpc.client.utils.retry.AwaitRetry;

public class SSLStompClient
extends SSLClient {
    private OneTimeCallback callback = new OneTimeCallback(){

        @Override
        public void execute() {
            if (SSLStompClient.this.connected.getCount() == 0L) {
                SSLStompClient.this.connected = new CountDownLatch(1);
            }
            if (SSLStompClient.this.subscribed.getCount() == 0L) {
                SSLStompClient.this.subscribed = new CountDownLatch(1);
            }
            this.subscribe(SSLStompClient.this.getResponseQueue());
            String eventQueue = SSLStompClient.this.getEventQueue();
            if (!JsonUtils.isEmpty(eventQueue)) {
                this.subscribe(eventQueue);
            }
            Message message = new Message().connect().withHeader("accept-version", "1.2").withHeader("host", SSLStompClient.this.policy.getIdentifier());
            int outgoing = 0;
            int incoming = 0;
            if (SSLStompClient.this.policy.isIncomingHeartbeat()) {
                incoming = SSLStompClient.this.policy.getIncomingHeartbeat();
            }
            if (SSLStompClient.this.policy.isOutgoingHeartbeat()) {
                outgoing = SSLStompClient.this.policy.getOutgoingHeartbeat();
            }
            if (incoming != 0 || outgoing != 0) {
                message.withHeader("heart-beat", outgoing + "," + JsonUtils.reduceGracePeriod(incoming));
            }
            SSLStompClient.this.sendNow(message.build());
        }

        private void subscribe(String queueName) {
            String subId = UUID.randomUUID().toString();
            SSLStompClient.this.subscriptionIds.add(subId);
            SSLStompClient.this.sendNow(new Message().subscribe().withHeader("destination", queueName).withHeader("id", subId).withHeader("ack", "auto").build());
        }
    };

    public SSLStompClient(Reactor reactor, Selector selector, String hostname, int port, SSLContext sslContext) {
        super(reactor, selector, hostname, port, sslContext);
        this.setWaitForConnect();
    }

    @Override
    public void sendMessage(byte[] message) {
        try {
            this.waitForConnect();
        }
        finally {
            this.send(new Message().send().withHeader("destination", this.getRequestQueue()).withHeader("reply-to", this.getResponseQueue()).withCorrelationId().withContent(message).build());
        }
    }

    @Override
    protected void postConnect(OneTimeCallback callback) throws ClientConnectionException {
        super.postConnect(this.getPostConnectCallback());
    }

    @Override
    protected OneTimeCallback getPostConnectCallback() {
        this.callback.resetExecution();
        this.setWaitForConnect();
        return this.callback;
    }

    private void setWaitForConnect() {
        this.connected = new CountDownLatch(1);
        this.subscribed = new CountDownLatch(1);
    }

    private void waitForConnect() {
        try {
            AwaitRetry.retry(() -> {
                this.connected.await(this.policy.getRetryTimeOut(), this.policy.getTimeUnit());
                return null;
            });
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.disconnect("Waiting for connect failed");
            throw new IllegalStateException("Communication failed");
        }
    }

    @Override
    public boolean isInInit() {
        return this.nioEngine == null || this.nioEngine.handshakeInProgress();
    }
}

