/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client.reactors.stomp;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.ovirt.vdsm.jsonrpc.client.ClientConnectionException;
import org.ovirt.vdsm.jsonrpc.client.internal.ClientPolicy;
import org.ovirt.vdsm.jsonrpc.client.reactors.Reactor;
import org.ovirt.vdsm.jsonrpc.client.reactors.SSLEngineNioHelper;
import org.ovirt.vdsm.jsonrpc.client.reactors.stomp.CommandFactory;
import org.ovirt.vdsm.jsonrpc.client.reactors.stomp.SSLStompClient;
import org.ovirt.vdsm.jsonrpc.client.reactors.stomp.impl.CommandExecutor;
import org.ovirt.vdsm.jsonrpc.client.reactors.stomp.impl.Message;
import org.ovirt.vdsm.jsonrpc.client.reactors.stomp.impl.Sender;
import org.ovirt.vdsm.jsonrpc.client.utils.JsonUtils;
import org.ovirt.vdsm.jsonrpc.client.utils.OneTimeCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLStompListener
extends SSLStompClient
implements Sender {
    private static Logger log = LoggerFactory.getLogger(SSLStompListener.class);
    private CommandFactory commandFactory;

    public SSLStompListener(Reactor reactor, Selector selector, String hostname, int port, SocketChannel socketChannel, SSLContext sslContext) throws ClientConnectionException {
        super(reactor, selector, hostname, port, sslContext);
        this.channel = socketChannel;
        this.commandFactory = new CommandFactory(this, this.eventListeners);
        this.postConnect(null);
    }

    @Override
    public void sendMessage(byte[] message) {
        this.send(new Message().message().withHeader("destination", "jms.queue.reponses").withContent(message).build());
    }

    @Override
    public void setClientPolicy(ClientPolicy policy) {
        this.policy = policy;
    }

    @Override
    void processMessage(Message message) {
        String command = message.getCommand();
        CommandExecutor executor = this.commandFactory.getCommandExecutor(command);
        Message response = executor.execute(message);
        if (Message.Command.CONNECT.toString().equals(command)) {
            this.updatePolicyWithHeartbeat(response.getHeaders().get("heart-beat"), false);
            if (message.getHeaders().get("host") != null) {
                this.policy.setIdentifier(message.getHeaders().get("host"));
            }
        }
        if (response != null) {
            this.send(response.build());
        }
        if (Message.Command.DISCONNECT.toString().equals(command)) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void postConnect(OneTimeCallback callback) throws ClientConnectionException {
        try {
            this.nioEngine = new SSLEngineNioHelper(this.channel, this.createSSLEngine(false), callback, this);
            this.nioEngine.beginHandshake();
            this.reactor.wakeup();
            this.key = this.channel.register(this.selector, 5, this);
        }
        catch (ClosedChannelException | SSLException e) {
            JsonUtils.logException(log, "Connection issues during ssl client creation", e);
            throw new ClientConnectionException(e);
        }
    }
}

