/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client.reactors.stomp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.ovirt.vdsm.jsonrpc.client.ClientConnectionException;
import org.ovirt.vdsm.jsonrpc.client.JsonRpcResponse;
import org.ovirt.vdsm.jsonrpc.client.internal.ClientPolicy;
import org.ovirt.vdsm.jsonrpc.client.reactors.Reactor;
import org.ovirt.vdsm.jsonrpc.client.reactors.ReactorClient;
import org.ovirt.vdsm.jsonrpc.client.reactors.stomp.StompClientPolicy;
import org.ovirt.vdsm.jsonrpc.client.reactors.stomp.impl.Message;
import org.ovirt.vdsm.jsonrpc.client.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StompCommonClient
extends ReactorClient {
    public static final String DEFAULT_REQUEST_QUEUE = "jms.queue.requests";
    public static final String DEFAULT_RESPONSE_QUEUE = "jms.queue.reponses";
    protected ByteBuffer headerBuffer = ByteBuffer.allocate(1024);
    protected Message message;
    protected CountDownLatch connected;
    protected CountDownLatch subscribed;
    protected List<String> subscriptionIds = new ArrayList<String>();
    private static final Logger LOG = LoggerFactory.getLogger(StompCommonClient.class);

    public StompCommonClient(Reactor reactor, String hostname, int port) {
        super(reactor, hostname, port);
    }

    public void send(byte[] message) {
        this.logMessageInTrace(message);
        this.outbox.addFirst(ByteBuffer.wrap(message));
        this.updateOps();
    }

    private void logMessageInTrace(byte[] message) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Message received: {}", (Object)new String(message, StandardCharsets.UTF_8));
        }
    }

    private void updateOps() {
        StompCommonClient client = this;
        this.scheduleTask(() -> {
            client.updateInterestedOps();
            return null;
        });
    }

    public void sendNow(byte[] message) {
        this.logMessageInTrace(message);
        this.outbox.addLast(ByteBuffer.wrap(message));
        this.updateOps();
    }

    void processMessage(Message message) {
        if (Message.Command.CONNECTED.toString().equals(message.getCommand())) {
            this.updatePolicyWithHeartbeat(message.getHeaders().get("heart-beat"), true);
            this.connected.countDown();
        } else if (Message.Command.ACK.toString().equals(message.getCommand())) {
            String headerId = message.getHeaders().get("id");
            if (!JsonUtils.isEmpty(headerId)) {
                this.subscribed.countDown();
            }
        } else if (Message.Command.ERROR.toString().equals(message.getCommand())) {
            String errorMessage = message.getHeaders().get("message");
            StringBuilder error = new StringBuilder();
            if (!JsonUtils.isEmpty(errorMessage)) {
                error.append(errorMessage);
            }
            if (message.getContent().length == 0) {
                error.append(errorMessage);
            }
            LOG.error("Error Message recieved: " + error);
        } else if (Message.Command.MESSAGE.toString().equals(message.getCommand())) {
            super.emitOnMessageReceived(message.getContent());
        }
    }

    @Override
    public Future<Void> close() {
        this.clean();
        this.subscriptionIds.forEach(subscriptionId -> this.send(new Message().unsubscribe().withHeader("id", (String)subscriptionId).build()));
        this.send(new Message().disconnect().withHeader("receipt", UUID.randomUUID().toString()).build());
        return super.close();
    }

    @Override
    protected void processIncoming() throws IOException, ClientConnectionException {
        if (this.ibuff == null) {
            int read = this.read(this.headerBuffer);
            if (read <= 0) {
                return;
            }
            this.updateLastIncomingHeartbeat();
            this.message = this.getMessage(this.headerBuffer, this.headerBuffer.position());
            if (this.message == null) {
                return;
            }
            int contentLength = this.message.getContentLength();
            if (contentLength == -1) {
                String[] messages;
                for (String msg : messages = new String(this.headerBuffer.array(), JsonUtils.UTF8).split("\u0000")) {
                    Message mesg = Message.parse((msg + "\u0000").getBytes(JsonUtils.UTF8));
                    int contLen = Objects.requireNonNull(mesg).getContentLength();
                    if (contLen != -1 && contLen != mesg.getContent().length - 1) {
                        this.message = mesg;
                        break;
                    }
                    this.emitOnMessageReceived(mesg);
                }
                return;
            }
            int length = this.message.getContent().length;
            if (contentLength == length - 1) {
                this.emitOnMessageReceived(this.message);
                return;
            }
            if (contentLength > length) {
                this.ibuff = ByteBuffer.allocate(contentLength - length + 1);
            } else {
                byte[] content = this.message.getContent();
                this.message.withContent(Arrays.copyOfRange(content, 0, contentLength + 1));
                this.emitOnMessageReceived(this.message);
                int from = contentLength + 1;
                if (from > content.length) {
                    from = content.length;
                }
                this.headerBuffer.put(Arrays.copyOfRange(content, from, content.length));
                return;
            }
        }
        this.read(this.ibuff);
        this.updateLastIncomingHeartbeat();
        int length = this.message.getContent().length + this.ibuff.position();
        if (this.message.getContentLength() != length - 1) {
            return;
        }
        this.message.withAdditionalContent(this.ibuff.array());
        this.emitOnMessageReceived(this.message);
    }

    private Message getMessage(ByteBuffer buffer, int read) throws ClientConnectionException {
        if (read > 1024) {
            read = 1024;
        }
        byte[] array = new byte[read];
        buffer.rewind();
        buffer.get(array);
        return Message.parse(array);
    }

    @Override
    protected void clean() {
        this.headerBuffer = ByteBuffer.allocate(1024);
        this.ibuff = null;
        this.message = null;
    }

    protected void emitOnMessageReceived(Message message) {
        message.trimEndOfMessage();
        this.clean();
        this.processMessage(message);
    }

    @Override
    protected byte[] buildNetworkResponse(String reason) {
        JsonRpcResponse response = JsonUtils.buildErrorResponse(null, this.getClientId(), reason);
        return response.toByteArray();
    }

    public void updatePolicyWithHeartbeat(String heartbeat, boolean client) {
        if (!JsonUtils.isEmpty(heartbeat)) {
            String[] heartbeats = heartbeat.split(",");
            try {
                int outgoing = Integer.parseInt(heartbeats[client ? 1 : 0]);
                int incoming = Integer.parseInt(heartbeats[client ? 0 : 1]);
                if (this.policy.getOutgoingHeartbeat() != outgoing) {
                    this.policy.setOutgoingHeartbeat(JsonUtils.reduceGracePeriod(outgoing));
                }
                if (this.policy.getIncomingHeartbeat() != incoming) {
                    this.policy.setIncomingHeartbeat(JsonUtils.addGracePeriod(incoming));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void sendHeartbeat() {
        this.send(Message.HEARTBEAT_FRAME);
    }

    @Override
    public void validate(ClientPolicy policy) {
        if (!StompClientPolicy.class.isInstance(policy)) {
            throw new IllegalStateException("Wrong policy type");
        }
    }

    public String getRequestQueue() {
        return ((StompClientPolicy)this.policy).getRequestQueue();
    }

    public String getResponseQueue() {
        return ((StompClientPolicy)this.policy).getResponseQueue();
    }

    public String getEventQueue() {
        return ((StompClientPolicy)this.policy).getEventQueue();
    }
}

