/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.vdsm.jsonrpc.client.utils.retry;

import java.util.concurrent.TimeUnit;
import org.ovirt.vdsm.jsonrpc.client.internal.ClientPolicy;

public class RetryContext {
    private int numberOfAttempts;
    private int timeout;
    private ClientPolicy policy;

    public RetryContext(ClientPolicy policy) {
        this.numberOfAttempts = policy.getRetryNumber();
        this.timeout = policy.getRetryTimeOut();
        this.policy = policy;
    }

    public boolean isExceptionRetryable(Exception e) {
        for (Class<? extends Exception> clazz : this.policy.getExceptions()) {
            if (!clazz.isInstance(e)) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfAttempts() {
        return this.numberOfAttempts;
    }

    public void waitOperation() throws InterruptedException {
        this.policy.getTimeUnit().sleep(this.timeout);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeUnit() {
        return this.policy.getTimeUnit();
    }

    public void decreaseAttempts() {
        --this.numberOfAttempts;
    }
}

