/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.provider.Arguments;
import org.objectweb.asm.test.ClassDump;

public abstract class AsmTest {
    private static final int INPUT_STREAM_DATA_CHUNK_SIZE = 4096;
    private static final String MODULE_INFO = "module-info";
    public static final String ALL_CLASSES_AND_ALL_APIS = "allClassesAndAllApis";
    public static final String ALL_CLASSES_AND_LATEST_API = "allClassesAndLatestApi";

    public static Stream<Arguments> allClassesAndAllApis() {
        return AsmTest.classesAndApis(Api.values());
    }

    public static Stream<Arguments> allClassesAndLatestApi() {
        return AsmTest.classesAndApis(Api.ASM7);
    }

    private static Stream<Arguments> classesAndApis(Api ... apis) {
        return Arrays.stream(PrecompiledClass.values()).flatMap(precompiledClass -> Arrays.stream(apis).map(api -> Arguments.of((Object[])new Object[]{precompiledClass, api})));
    }

    private static int getMajorJavaVersion() {
        String javaVersion = System.getProperty("java.version");
        String javaMajorVersion = new StringTokenizer(javaVersion, "._").nextToken();
        return Integer.parseInt(javaMajorVersion);
    }

    public static ClassSubject assertThatClass(byte[] classFile) {
        return new ClassSubject(classFile);
    }

    public static boolean loadAndInstantiate(String className, byte[] classContent) {
        try {
            new ClassDump(classContent);
        }
        catch (IOException | IllegalArgumentException e) {
            Assertions.fail((String)"Class can't be dumped, probably invalid", (Throwable)e);
        }
        if (className.endsWith(MODULE_INFO)) {
            if (AsmTest.getMajorJavaVersion() < 9) {
                throw new UnsupportedClassVersionError();
            }
            return true;
        }
        return AsmTest.doLoadAndInstantiate(className, classContent);
    }

    static boolean doLoadAndInstantiate(String className, byte[] classContent) {
        ByteClassLoader byteClassLoader = new ByteClassLoader(className, classContent);
        try {
            Class<?> clazz = byteClassLoader.loadClass(className);
            if (!clazz.isEnum() && (clazz.getModifiers() & 0x400) == 0) {
                Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
                ArrayList<Object> arguments = new ArrayList<Object>();
                for (Class<?> parameterType : constructor.getParameterTypes()) {
                    arguments.add(Array.get(Array.newInstance(parameterType, 1), 0));
                }
                constructor.setAccessible(true);
                constructor.newInstance(arguments.toArray(new Object[0]));
            }
        }
        catch (ClassNotFoundException e) {
            Assertions.fail((String)("Can't find class " + className), (Throwable)e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            Assertions.fail((String)("Can't instantiate class " + className), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Assertions.fail((String)("An exception occurred in the constructor of " + className), (Throwable)e);
        }
        return byteClassLoader.classLoaded();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getBytes(String name) {
        String resourceName = name.replace('.', '/') + ".class";
        try (InputStream inputStream = ClassLoader.getSystemResourceAsStream(resourceName);){
            int bytesRead;
            Assertions.assertNotNull((Object)inputStream, (String)("Class not found " + name));
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] data = new byte[4096];
            while ((bytesRead = inputStream.read(data, 0, data.length)) != -1) {
                outputStream.write(data, 0, bytesRead);
            }
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            Assertions.fail((String)("Can't read " + name), (Throwable)e);
            return new byte[0];
        }
    }

    private static class ByteClassLoader
    extends ClassLoader {
        private final String className;
        private final byte[] classContent;
        private boolean classLoaded;

        ByteClassLoader(String className, byte[] classContent) {
            this.className = className;
            this.classContent = classContent;
        }

        boolean classLoaded() {
            return this.classLoaded;
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.equals(this.className)) {
                this.classLoaded = true;
                return this.defineClass(this.className, this.classContent, 0, this.classContent.length);
            }
            return super.loadClass(name, resolve);
        }
    }

    public static class ClassSubject {
        private final byte[] classFile;

        ClassSubject(byte[] classFile) {
            this.classFile = classFile;
        }

        public void contains(String expectedString) {
            try {
                String dump = new ClassDump(this.classFile).toString();
                Assertions.assertTrue((boolean)dump.contains(expectedString));
            }
            catch (IOException | IllegalArgumentException e) {
                Assertions.fail((String)"Class can't be dumped", (Throwable)e);
            }
        }

        public void isEqualTo(byte[] expectedClassFile) {
            try {
                String dump = new ClassDump(this.classFile).toString();
                String expectedDump = new ClassDump(expectedClassFile).toString();
                Assertions.assertEquals((Object)expectedDump, (Object)dump);
            }
            catch (IOException | IllegalArgumentException e) {
                Assertions.fail((String)"Class can't be dumped", (Throwable)e);
            }
        }
    }

    public static enum Api {
        ASM4("ASM4", 262144),
        ASM5("ASM5", 327680),
        ASM6("ASM6", 393216),
        ASM7("ASM7", 458752);

        private final String name;
        private final int value;

        private Api(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum InvalidClass {
        INVALID_BYTECODE_OFFSET("invalid.InvalidBytecodeOffset"),
        INVALID_CLASS_VERSION("invalid.InvalidClassVersion"),
        INVALID_CONSTANT_POOL_INDEX("invalid.InvalidConstantPoolIndex"),
        INVALID_CONSTANT_POOL_REFERENCE("invalid.InvalidConstantPoolReference"),
        INVALID_CP_INFO_TAG("invalid.InvalidCpInfoTag"),
        INVALID_ELEMENT_VALUE("invalid.InvalidElementValue"),
        INVALID_INSN_TYPE_ANNOTATION_TARGET_TYPE("invalid.InvalidInsnTypeAnnotationTargetType"),
        INVALID_OPCODE("invalid.InvalidOpcode"),
        INVALID_STACK_MAP_FRAME_TYPE("invalid.InvalidStackMapFrameType"),
        INVALID_TYPE_ANNOTATION_TARGET_TYPE("invalid.InvalidTypeAnnotationTargetType"),
        INVALID_VERIFICATION_TYPE_INFO("invalid.InvalidVerificationTypeInfo"),
        INVALID_WIDE_OPCODE("invalid.InvalidWideOpcode");

        private final String name;

        private InvalidClass(String name) {
            this.name = name;
        }

        public byte[] getBytes() {
            return AsmTest.getBytes(this.name);
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum PrecompiledClass {
        DEFAULT_PACKAGE("DefaultPackage"),
        JDK3_ALL_INSTRUCTIONS("jdk3.AllInstructions"),
        JDK3_ALL_STRUCTURES("jdk3.AllStructures"),
        JDK3_ANONYMOUS_INNER_CLASS("jdk3.AllStructures$1"),
        JDK3_ARTIFICIAL_STRUCTURES("jdk3.ArtificialStructures"),
        JDK3_INNER_CLASS("jdk3.AllStructures$InnerClass"),
        JDK3_LARGE_METHOD("jdk3.LargeMethod"),
        JDK5_ALL_INSTRUCTIONS("jdk5.AllInstructions"),
        JDK5_ALL_STRUCTURES("jdk5.AllStructures"),
        JDK5_ANNOTATION("jdk5.AllStructures$InvisibleAnnotation"),
        JDK5_ENUM("jdk5.AllStructures$EnumClass"),
        JDK5_LOCAL_CLASS("jdk5.AllStructures$1LocalClass"),
        JDK8_ALL_FRAMES("jdk8.AllFrames"),
        JDK8_ALL_INSTRUCTIONS("jdk8.AllInstructions"),
        JDK8_ALL_STRUCTURES("jdk8.AllStructures"),
        JDK8_ANONYMOUS_INNER_CLASS("jdk8.AllStructures$1"),
        JDK8_ARTIFICIAL_STRUCTURES("jdk8.ArtificialStructures"),
        JDK8_INNER_CLASS("jdk8.AllStructures$InnerClass"),
        JDK8_LARGE_METHOD("jdk8.LargeMethod"),
        JDK9_MODULE("jdk9.module-info"),
        JDK11_ALL_INSTRUCTIONS("jdk11.AllInstructions"),
        JDK11_ALL_STRUCTURES("jdk11.AllStructures"),
        JDK11_ALL_STRUCTURES_NESTED("jdk11.AllStructures$Nested");

        private final String name;

        private PrecompiledClass(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getInternalName() {
            return this.name.endsWith(AsmTest.MODULE_INFO) ? AsmTest.MODULE_INFO : this.name.replace('.', '/');
        }

        public boolean isMoreRecentThan(Api api) {
            if (this.name.startsWith("jdk8.") && api.value() < Api.ASM5.value()) {
                return true;
            }
            if (this.name.startsWith("jdk9.") && api.value() < Api.ASM6.value()) {
                return true;
            }
            return this.name.startsWith("jdk11.") && api.value() < Api.ASM7.value();
        }

        public boolean isMoreRecentThanCurrentJdk() {
            if (this.name.startsWith("jdk9.")) {
                return AsmTest.getMajorJavaVersion() < 9;
            }
            if (this.name.startsWith("jdk11.")) {
                return AsmTest.getMajorJavaVersion() < 11;
            }
            return false;
        }

        public byte[] getBytes() {
            return AsmTest.getBytes(this.name);
        }

        public String toString() {
            return this.name;
        }
    }
}

