/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.test;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

class ClassDump {
    private final String dump;

    ClassDump(byte[] bytecode) throws IOException {
        Builder builder = new Builder("ClassFile", null);
        ClassDump.dumpClassFile(new Parser(bytecode), builder);
        StringBuilder stringBuilder = new StringBuilder();
        builder.build(stringBuilder);
        this.dump = stringBuilder.toString();
    }

    public String toString() {
        return this.dump;
    }

    private static void dumpClassFile(Parser parser, Builder builder) throws IOException {
        CpInfo cpInfo;
        builder.add("magic: ", parser.u4());
        builder.add("minor_version: ", parser.u2());
        int majorVersion = parser.u2();
        if (majorVersion > 56) {
            throw new IOException("Unsupported class version");
        }
        builder.add("major_version: ", majorVersion);
        int constantPoolCount = parser.u2();
        for (int cpIndex = 1; cpIndex < constantPoolCount; cpIndex += cpInfo.size()) {
            cpInfo = ClassDump.parseCpInfo(parser, builder);
            builder.putCpInfo(cpIndex, cpInfo);
        }
        builder.add("access_flags: ", parser.u2());
        builder.addCpInfo("this_class: ", parser.u2());
        builder.addCpInfo("super_class: ", parser.u2());
        int interfaceCount = builder.add("interfaces_count: ", parser.u2());
        for (int i = 0; i < interfaceCount; ++i) {
            builder.addCpInfo("interface: ", parser.u2());
        }
        int fieldCount = builder.add("fields_count: ", parser.u2());
        for (int i = 0; i < fieldCount; ++i) {
            ClassDump.dumpFieldInfo(parser, builder);
        }
        int methodCount = builder.add("methods_count: ", parser.u2());
        for (int i = 0; i < methodCount; ++i) {
            ClassDump.dumpMethodInfo(parser, builder);
        }
        ClassDump.dumpAttributeList(parser, builder);
    }

    private static void dumpAttributeList(Parser parser, Builder builder) throws IOException {
        int attributeCount = builder.add("attributes_count: ", parser.u2());
        SortedBuilder sortedBuilder = builder.addSortedBuilder();
        for (int i = 0; i < attributeCount; ++i) {
            ClassDump.dumpAttributeInfo(parser, sortedBuilder);
        }
    }

    private static CpInfo parseCpInfo(Parser parser, ClassContext classContext) throws IOException {
        int tag = parser.u1();
        switch (tag) {
            case 7: {
                return new ConstantClassInfo(parser, classContext);
            }
            case 9: {
                return new ConstantFieldRefInfo(parser, classContext);
            }
            case 10: {
                return new ConstantMethodRefInfo(parser, classContext);
            }
            case 11: {
                return new ConstantInterfaceMethodRefInfo(parser, classContext);
            }
            case 8: {
                return new ConstantStringInfo(parser, classContext);
            }
            case 3: {
                return new ConstantIntegerInfo(parser);
            }
            case 4: {
                return new ConstantFloatInfo(parser);
            }
            case 5: {
                return new ConstantLongInfo(parser);
            }
            case 6: {
                return new ConstantDoubleInfo(parser);
            }
            case 12: {
                return new ConstantNameAndTypeInfo(parser, classContext);
            }
            case 1: {
                return new ConstantUtf8Info(parser);
            }
            case 15: {
                return new ConstantMethodHandleInfo(parser, classContext);
            }
            case 16: {
                return new ConstantMethodTypeInfo(parser, classContext);
            }
            case 17: {
                return new ConstantDynamicInfo(parser, classContext);
            }
            case 18: {
                return new ConstantInvokeDynamicInfo(parser, classContext);
            }
            case 19: {
                return new ConstantModuleInfo(parser, classContext);
            }
            case 20: {
                return new ConstantPackageInfo(parser, classContext);
            }
        }
        throw new IOException("Invalid constant pool item tag " + tag);
    }

    private static void dumpFieldInfo(Parser parser, Builder builder) throws IOException {
        builder.add("access_flags: ", parser.u2());
        builder.addCpInfo("name_index: ", parser.u2());
        builder.addCpInfo("descriptor_index: ", parser.u2());
        ClassDump.dumpAttributeList(parser, builder);
    }

    private static void dumpMethodInfo(Parser parser, Builder builder) throws IOException {
        ClassDump.dumpFieldInfo(parser, builder);
    }

    private static void dumpAttributeInfo(Parser parser, SortedBuilder sortedBuilder) throws IOException {
        String attributeName = sortedBuilder.getCpInfo(parser.u2()).toString();
        int attributeLength = parser.u4();
        Builder builder = sortedBuilder.addBuilder(attributeName);
        builder.add("attribute_name_index: ", attributeName);
        if (attributeName.equals("ConstantValue")) {
            ClassDump.dumpConstantValueAttribute(parser, builder);
        } else if (attributeName.equals("Code")) {
            ClassDump.dumpCodeAttribute(parser, builder);
        } else if (attributeName.equals("StackMapTable")) {
            ClassDump.dumpStackMapTableAttribute(parser, builder);
        } else if (attributeName.equals("Exceptions")) {
            ClassDump.dumpExceptionsAttribute(parser, builder);
        } else if (attributeName.equals("InnerClasses")) {
            ClassDump.dumpInnerClassesAttribute(parser, builder);
        } else if (attributeName.equals("EnclosingMethod")) {
            ClassDump.dumpEnclosingMethodAttribute(parser, builder);
        } else if (attributeName.equals("Synthetic")) {
            ClassDump.dumpSyntheticAttribute();
        } else if (attributeName.equals("Signature")) {
            ClassDump.dumpSignatureAttribute(parser, builder);
        } else if (attributeName.equals("SourceFile")) {
            ClassDump.dumpSourceFileAttribute(parser, builder);
        } else if (attributeName.equals("SourceDebugExtension")) {
            ClassDump.dumpSourceDebugAttribute(attributeLength, parser, builder);
        } else if (attributeName.equals("LineNumberTable")) {
            ClassDump.dumpLineNumberTableAttribute(parser, builder);
        } else if (attributeName.equals("LocalVariableTable")) {
            ClassDump.dumpLocalVariableTableAttribute(parser, builder);
        } else if (attributeName.equals("LocalVariableTypeTable")) {
            ClassDump.dumpLocalVariableTypeTableAttribute(parser, builder);
        } else if (attributeName.equals("Deprecated")) {
            ClassDump.dumpDeprecatedAttribute();
        } else if (attributeName.equals("RuntimeVisibleAnnotations")) {
            ClassDump.dumpRuntimeVisibleAnnotationsAttribute(parser, builder);
        } else if (attributeName.equals("RuntimeInvisibleAnnotations")) {
            ClassDump.dumpRuntimeInvisibleAnnotationsAttribute(parser, builder);
        } else if (attributeName.equals("RuntimeVisibleParameterAnnotations")) {
            ClassDump.dumpRuntimeVisibleParameterAnnotationsAttribute(parser, builder);
        } else if (attributeName.equals("RuntimeInvisibleParameterAnnotations")) {
            ClassDump.dumpRuntimeInvisibleParameterAnnotationsAttribute(parser, builder);
        } else if (attributeName.equals("RuntimeVisibleTypeAnnotations")) {
            ClassDump.dumpRuntimeVisibleTypeAnnotationsAttribute(parser, builder);
        } else if (attributeName.equals("RuntimeInvisibleTypeAnnotations")) {
            ClassDump.dumpRuntimeInvisibleTypeAnnotationsAttribute(parser, builder);
        } else if (attributeName.equals("AnnotationDefault")) {
            ClassDump.dumpAnnotationDefaultAttribute(parser, builder);
        } else if (attributeName.equals("BootstrapMethods")) {
            ClassDump.dumpBootstrapMethodsAttribute(parser, builder);
        } else if (attributeName.equals("MethodParameters")) {
            ClassDump.dumpMethodParametersAttribute(parser, builder);
        } else if (attributeName.equals("Module")) {
            ClassDump.dumpModuleAttribute(parser, builder);
        } else if (attributeName.equals("ModulePackages")) {
            ClassDump.dumpModulePackagesAttribute(parser, builder);
        } else if (attributeName.equals("ModuleMainClass")) {
            ClassDump.dumpModuleMainClassAttribute(parser, builder);
        } else if (attributeName.equals("NestHost")) {
            ClassDump.dumpNestHostAttribute(parser, builder);
        } else if (attributeName.equals("NestMembers")) {
            ClassDump.dumpNestMembersAttribute(parser, builder);
        } else if (attributeName.equals("StackMap")) {
            ClassDump.dumpStackMapAttribute(parser, builder);
        } else if (!attributeName.equals("CodeComment") && !attributeName.equals("Comment")) {
            throw new IOException("Unknown attribute " + attributeName);
        }
    }

    private static void dumpConstantValueAttribute(Parser parser, Builder builder) throws IOException {
        builder.addCpInfo("constantvalue_index: ", parser.u2());
    }

    private static void dumpCodeAttribute(Parser parser, Builder builder) throws IOException {
        builder.add("max_stack: ", parser.u2());
        builder.add("max_locals: ", parser.u2());
        int codeLength = parser.u4();
        ClassDump.dumpInstructions(codeLength, parser, builder);
        int exceptionCount = builder.add("exception_table_length: ", parser.u2());
        for (int i = 0; i < exceptionCount; ++i) {
            builder.addInsnIndex("start_pc: ", parser.u2());
            builder.addInsnIndex("end_pc: ", parser.u2());
            builder.addInsnIndex("handler_pc: ", parser.u2());
            builder.addCpInfo("catch_type: ", parser.u2());
        }
        ClassDump.dumpAttributeList(parser, builder);
    }

    private static void dumpInstructions(int codeLength, Parser parser, Builder builder) throws IOException {
        int bytecodeOffset = 0;
        int insnIndex = 0;
        while (bytecodeOffset < codeLength) {
            builder.putInsnIndex(bytecodeOffset, insnIndex);
            int opcode = parser.u1();
            int startOffset = bytecodeOffset++;
            block0 : switch (opcode) {
                case 1: 
                case 50: 
                case 83: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 25: {
                    builder.addInsn(insnIndex, opcode, parser.u1());
                    ++bytecodeOffset;
                    break;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    builder.addInsn(insnIndex, 25, opcode - 42);
                    break;
                }
                case 189: {
                    builder.addInsn(insnIndex, opcode, builder.getCpInfo(parser.u2()));
                    bytecodeOffset += 2;
                    break;
                }
                case 176: 
                case 190: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 58: {
                    builder.addInsn(insnIndex, opcode, parser.u1());
                    ++bytecodeOffset;
                    break;
                }
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    builder.addInsn(insnIndex, 58, opcode - 75);
                    break;
                }
                case 51: 
                case 84: 
                case 191: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 16: {
                    builder.addInsn(insnIndex, opcode, parser.u1());
                    ++bytecodeOffset;
                    break;
                }
                case 52: 
                case 85: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 192: {
                    builder.addInsn(insnIndex, opcode, builder.getCpInfo(parser.u2()));
                    bytecodeOffset += 2;
                    break;
                }
                case 14: 
                case 15: 
                case 49: 
                case 82: 
                case 99: 
                case 111: 
                case 142: 
                case 143: 
                case 144: 
                case 151: 
                case 152: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 24: {
                    builder.addInsn(insnIndex, opcode, parser.u1());
                    ++bytecodeOffset;
                    break;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    builder.addInsn(insnIndex, 24, opcode - 38);
                    break;
                }
                case 107: 
                case 115: 
                case 119: 
                case 175: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 57: {
                    builder.addInsn(insnIndex, opcode, parser.u1());
                    ++bytecodeOffset;
                    break;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: {
                    builder.addInsn(insnIndex, 57, opcode - 71);
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 48: 
                case 81: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 98: 
                case 103: 
                case 110: 
                case 139: 
                case 140: 
                case 141: 
                case 149: 
                case 150: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 23: {
                    builder.addInsn(insnIndex, opcode, parser.u1());
                    ++bytecodeOffset;
                    break;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    builder.addInsn(insnIndex, 23, opcode - 34);
                    break;
                }
                case 106: 
                case 114: 
                case 118: 
                case 174: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 56: {
                    builder.addInsn(insnIndex, opcode, parser.u1());
                    ++bytecodeOffset;
                    break;
                }
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    builder.addInsn(insnIndex, 56, opcode - 67);
                    break;
                }
                case 102: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 178: 
                case 180: {
                    builder.addInsn(insnIndex, opcode, builder.getCpInfo(parser.u2()));
                    bytecodeOffset += 2;
                    break;
                }
                case 167: {
                    builder.addInsn(insnIndex, opcode, new InstructionIndex(startOffset + parser.s2(), builder));
                    bytecodeOffset += 2;
                    break;
                }
                case 200: {
                    builder.addInsn(insnIndex, 167, new InstructionIndex(startOffset + parser.u4(), builder));
                    bytecodeOffset += 4;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 46: 
                case 79: 
                case 96: 
                case 108: 
                case 126: 
                case 133: 
                case 134: 
                case 135: 
                case 145: 
                case 146: 
                case 147: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    builder.addInsn(insnIndex, opcode, new InstructionIndex(startOffset + parser.s2(), builder));
                    bytecodeOffset += 2;
                    break;
                }
                case 132: {
                    builder.addInsn(insnIndex, opcode, parser.u1(), parser.s1());
                    bytecodeOffset += 2;
                    break;
                }
                case 21: {
                    builder.addInsn(insnIndex, opcode, parser.u1());
                    ++bytecodeOffset;
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    builder.addInsn(insnIndex, 21, opcode - 26);
                    break;
                }
                case 104: 
                case 116: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 193: {
                    builder.addInsn(insnIndex, opcode, builder.getCpInfo(parser.u2()));
                    bytecodeOffset += 2;
                    break;
                }
                case 186: {
                    builder.addInsn(insnIndex, opcode, builder.getCpInfo(parser.u2()));
                    parser.u2();
                    bytecodeOffset += 4;
                    break;
                }
                case 185: {
                    builder.addInsn(insnIndex, opcode, builder.getCpInfo(parser.u2()), parser.u1());
                    parser.u1();
                    bytecodeOffset += 4;
                    break;
                }
                case 182: 
                case 183: 
                case 184: {
                    builder.addInsn(insnIndex, opcode, builder.getCpInfo(parser.u2()));
                    bytecodeOffset += 2;
                    break;
                }
                case 112: 
                case 120: 
                case 122: 
                case 128: 
                case 172: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 54: {
                    builder.addInsn(insnIndex, opcode, parser.u1());
                    ++bytecodeOffset;
                    break;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    builder.addInsn(insnIndex, 54, opcode - 59);
                    break;
                }
                case 100: 
                case 124: 
                case 130: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 168: {
                    builder.addInsn(insnIndex, opcode, new InstructionIndex(startOffset + parser.s2(), builder));
                    bytecodeOffset += 2;
                    break;
                }
                case 201: {
                    builder.addInsn(insnIndex, 168, new InstructionIndex(startOffset + parser.u4(), builder));
                    bytecodeOffset += 4;
                    break;
                }
                case 9: 
                case 10: 
                case 47: 
                case 80: 
                case 97: 
                case 127: 
                case 136: 
                case 137: 
                case 138: 
                case 148: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 18: {
                    builder.addInsn(insnIndex, 18, builder.getCpInfo(parser.u1()));
                    ++bytecodeOffset;
                    break;
                }
                case 19: 
                case 20: {
                    builder.addInsn(insnIndex, opcode == 19 ? 18 : 20, builder.getCpInfo(parser.u2()));
                    bytecodeOffset += 2;
                    break;
                }
                case 109: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 22: {
                    builder.addInsn(insnIndex, opcode, parser.u1());
                    ++bytecodeOffset;
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    builder.addInsn(insnIndex, 22, opcode - 30);
                    break;
                }
                case 105: 
                case 117: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 171: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    while (bytecodeOffset % 4 != 0) {
                        parser.u1();
                        ++bytecodeOffset;
                    }
                    builder.addInsnIndex("default: ", startOffset + parser.u4());
                    int pairCount = builder.add("npairs: ", parser.u4());
                    bytecodeOffset += 8;
                    for (int i = 0; i < pairCount; ++i) {
                        builder.addInsnIndex(parser.u4() + ": ", startOffset + parser.u4());
                        bytecodeOffset += 8;
                    }
                    break;
                }
                case 113: 
                case 121: 
                case 123: 
                case 129: 
                case 173: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 55: {
                    builder.addInsn(insnIndex, opcode, parser.u1());
                    ++bytecodeOffset;
                    break;
                }
                case 63: 
                case 64: 
                case 65: 
                case 66: {
                    builder.addInsn(insnIndex, 55, opcode - 63);
                    break;
                }
                case 101: 
                case 125: 
                case 131: 
                case 194: 
                case 195: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 197: {
                    builder.addInsn(insnIndex, opcode, builder.getCpInfo(parser.u2()), parser.u1());
                    bytecodeOffset += 3;
                    break;
                }
                case 187: {
                    builder.addInsn(insnIndex, opcode, builder.getCpInfo(parser.u2()));
                    bytecodeOffset += 2;
                    break;
                }
                case 188: {
                    builder.addInsn(insnIndex, opcode, parser.u1());
                    ++bytecodeOffset;
                    break;
                }
                case 0: 
                case 87: 
                case 88: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 179: 
                case 181: {
                    builder.addInsn(insnIndex, opcode, builder.getCpInfo(parser.u2()));
                    bytecodeOffset += 2;
                    break;
                }
                case 169: {
                    builder.addInsn(insnIndex, opcode, parser.u1());
                    ++bytecodeOffset;
                    break;
                }
                case 53: 
                case 86: 
                case 177: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 17: {
                    builder.addInsn(insnIndex, opcode, parser.s2());
                    bytecodeOffset += 2;
                    break;
                }
                case 95: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    break;
                }
                case 170: {
                    builder.addInsn(insnIndex, opcode, new Object[0]);
                    while (bytecodeOffset % 4 != 0) {
                        parser.u1();
                        ++bytecodeOffset;
                    }
                    builder.addInsnIndex("default: ", startOffset + parser.u4());
                    int low = builder.add("low: ", parser.u4());
                    int high = builder.add("high: ", parser.u4());
                    bytecodeOffset += 12;
                    for (int i = low; i <= high; ++i) {
                        builder.addInsnIndex(i + ": ", startOffset + parser.u4());
                        bytecodeOffset += 4;
                    }
                    break;
                }
                case 196: {
                    opcode = parser.u1();
                    ++bytecodeOffset;
                    switch (opcode) {
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 169: {
                            builder.addInsn(insnIndex, opcode, parser.u2());
                            bytecodeOffset += 2;
                            break block0;
                        }
                        case 132: {
                            builder.addInsn(insnIndex, opcode, parser.u2(), parser.s2());
                            bytecodeOffset += 4;
                            break block0;
                        }
                    }
                    throw new IOException("Unknown wide opcode: " + opcode);
                }
                default: {
                    throw new IOException("Unknown opcode: " + opcode);
                }
            }
            ++insnIndex;
        }
        builder.putInsnIndex(bytecodeOffset, insnIndex);
    }

    private static void dumpStackMapTableAttribute(Parser parser, Builder builder) throws IOException {
        int entryCount = builder.add("number_of_entries: ", parser.u2());
        int bytecodeOffset = -1;
        for (int i = 0; i < entryCount; ++i) {
            int offsetDelta;
            int frameType = parser.u1();
            if (frameType < 64) {
                offsetDelta = frameType;
                builder.addInsnIndex("SAME ", bytecodeOffset += offsetDelta + 1);
                continue;
            }
            if (frameType < 128) {
                offsetDelta = frameType - 64;
                builder.addInsnIndex("SAME_LOCALS_1_STACK_ITEM ", bytecodeOffset += offsetDelta + 1);
                ClassDump.dumpVerificationTypeInfo(parser, builder);
                continue;
            }
            if (frameType < 247) {
                throw new IOException("Unknown frame type " + frameType);
            }
            if (frameType == 247) {
                offsetDelta = parser.u2();
                builder.addInsnIndex("SAME_LOCALS_1_STACK_ITEM ", bytecodeOffset += offsetDelta + 1);
                ClassDump.dumpVerificationTypeInfo(parser, builder);
                continue;
            }
            if (frameType < 251) {
                offsetDelta = parser.u2();
                builder.addInsnIndex("CHOP_" + (251 - frameType) + " ", bytecodeOffset += offsetDelta + 1);
                continue;
            }
            if (frameType == 251) {
                offsetDelta = parser.u2();
                builder.addInsnIndex("SAME ", bytecodeOffset += offsetDelta + 1);
                continue;
            }
            if (frameType < 255) {
                offsetDelta = parser.u2();
                builder.addInsnIndex("APPEND_" + (frameType - 251) + " ", bytecodeOffset += offsetDelta + 1);
                for (int j = 0; j < frameType - 251; ++j) {
                    ClassDump.dumpVerificationTypeInfo(parser, builder);
                }
                continue;
            }
            offsetDelta = parser.u2();
            builder.addInsnIndex("FULL ", bytecodeOffset += offsetDelta + 1);
            int numberOfLocals = builder.add("number_of_locals: ", parser.u2());
            for (int j = 0; j < numberOfLocals; ++j) {
                ClassDump.dumpVerificationTypeInfo(parser, builder);
            }
            int numberOfStackItems = builder.add("number_of_stack_items: ", parser.u2());
            for (int j = 0; j < numberOfStackItems; ++j) {
                ClassDump.dumpVerificationTypeInfo(parser, builder);
            }
        }
    }

    private static void dumpVerificationTypeInfo(Parser parser, Builder builder) throws IOException {
        int tag = builder.add("tag: ", parser.u1());
        if (tag > 8) {
            throw new IOException("Unknown verification_type_info tag: " + tag);
        }
        if (tag == 7) {
            builder.addCpInfo("cpool_index: ", parser.u2());
        } else if (tag == 8) {
            builder.addInsnIndex("offset: ", parser.u2());
        }
    }

    private static void dumpExceptionsAttribute(Parser parser, Builder builder) throws IOException {
        int exceptionCount = builder.add("number_of_exceptions: ", parser.u2());
        for (int i = 0; i < exceptionCount; ++i) {
            builder.addCpInfo("exception_index: ", parser.u2());
        }
    }

    private static void dumpInnerClassesAttribute(Parser parser, Builder builder) throws IOException {
        int classCount = builder.add("number_of_classes: ", parser.u2());
        for (int i = 0; i < classCount; ++i) {
            builder.addCpInfo("inner_class_info_index: ", parser.u2());
            builder.addCpInfo("outer_class_info_index: ", parser.u2());
            builder.addCpInfo("inner_name_index: ", parser.u2());
            builder.add("inner_class_access_flags: ", parser.u2());
        }
    }

    private static void dumpEnclosingMethodAttribute(Parser parser, Builder builder) throws IOException {
        builder.addCpInfo("class_index: ", parser.u2());
        builder.addCpInfo("method_index: ", parser.u2());
    }

    private static void dumpSyntheticAttribute() {
    }

    private static void dumpSignatureAttribute(Parser parser, Builder builder) throws IOException {
        builder.addCpInfo("signature_index: ", parser.u2());
    }

    private static void dumpSourceFileAttribute(Parser parser, Builder builder) throws IOException {
        builder.addCpInfo("sourcefile_index: ", parser.u2());
    }

    private static void dumpSourceDebugAttribute(int attributeLength, Parser parser, Builder builder) throws IOException {
        byte[] attributeData = parser.bytes(attributeLength);
        StringBuilder stringBuilder = new StringBuilder();
        for (byte data : attributeData) {
            stringBuilder.append(data).append(',');
        }
        builder.add("debug_extension: ", stringBuilder.toString());
    }

    private static void dumpLineNumberTableAttribute(Parser parser, Builder builder) throws IOException {
        int lineNumberCount = builder.add("line_number_table_length: ", parser.u2());
        for (int i = 0; i < lineNumberCount; ++i) {
            builder.addInsnIndex("start_pc: ", parser.u2());
            builder.add("line_number: ", parser.u2());
        }
    }

    private static void dumpLocalVariableTableAttribute(Parser parser, Builder builder) throws IOException {
        int localVariableCount = builder.add("local_variable_table_length: ", parser.u2());
        for (int i = 0; i < localVariableCount; ++i) {
            int startPc = builder.addInsnIndex("start_pc: ", parser.u2());
            builder.addInsnIndex("length: ", startPc + parser.u2());
            builder.addCpInfo("name_index: ", parser.u2());
            builder.addCpInfo("descriptor_index: ", parser.u2());
            builder.add("index: ", parser.u2());
        }
    }

    private static void dumpLocalVariableTypeTableAttribute(Parser parser, Builder builder) throws IOException {
        int localVariableCount = builder.add("local_variable_type_table_length: ", parser.u2());
        for (int i = 0; i < localVariableCount; ++i) {
            int startPc = builder.addInsnIndex("start_pc: ", parser.u2());
            builder.addInsnIndex("length: ", startPc + parser.u2());
            builder.addCpInfo("name_index: ", parser.u2());
            builder.addCpInfo("signature_index: ", parser.u2());
            builder.add("index: ", parser.u2());
        }
    }

    private static void dumpDeprecatedAttribute() {
    }

    private static void dumpRuntimeVisibleAnnotationsAttribute(Parser parser, Builder builder) throws IOException {
        int annotationCount = builder.add("num_annotations: ", parser.u2());
        for (int i = 0; i < annotationCount; ++i) {
            ClassDump.dumpAnnotation(parser, builder);
        }
    }

    private static void dumpAnnotation(Parser parser, Builder builder) throws IOException {
        builder.addCpInfo("type_index: ", parser.u2());
        int elementValuePairCount = builder.add("num_element_value_pairs: ", parser.u2());
        for (int i = 0; i < elementValuePairCount; ++i) {
            builder.addCpInfo("element_name_index: ", parser.u2());
            ClassDump.dumpElementValue(parser, builder);
        }
    }

    private static void dumpElementValue(Parser parser, Builder builder) throws IOException {
        int tag = parser.u1();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                builder.addCpInfo((char)tag + ": ", parser.u2());
                return;
            }
            case 101: {
                builder.addCpInfo("e: ", parser.u2());
                builder.addCpInfo("const_name_index: ", parser.u2());
                return;
            }
            case 99: {
                builder.addCpInfo((char)tag + ": ", parser.u2());
                return;
            }
            case 64: {
                builder.add("@: ", "");
                ClassDump.dumpAnnotation(parser, builder);
                return;
            }
            case 91: {
                int valueCount = builder.add("[: ", parser.u2());
                for (int i = 0; i < valueCount; ++i) {
                    ClassDump.dumpElementValue(parser, builder);
                }
                return;
            }
        }
        throw new IOException("Unknown element_type tag: " + tag);
    }

    private static void dumpRuntimeInvisibleAnnotationsAttribute(Parser parser, Builder builder) throws IOException {
        ClassDump.dumpRuntimeVisibleAnnotationsAttribute(parser, builder);
    }

    private static void dumpRuntimeVisibleParameterAnnotationsAttribute(Parser parser, Builder builder) throws IOException {
        int parameterCount = builder.add("num_parameters: ", parser.u1());
        for (int i = 0; i < parameterCount; ++i) {
            int annotationCount = builder.add("num_annotations: ", parser.u2());
            for (int j = 0; j < annotationCount; ++j) {
                ClassDump.dumpAnnotation(parser, builder);
            }
        }
    }

    private static void dumpRuntimeInvisibleParameterAnnotationsAttribute(Parser parser, Builder builder) throws IOException {
        ClassDump.dumpRuntimeVisibleParameterAnnotationsAttribute(parser, builder);
    }

    private static void dumpRuntimeVisibleTypeAnnotationsAttribute(Parser parser, Builder builder) throws IOException {
        int annotationCount = builder.add("num_annotations: ", parser.u2());
        SortedBuilder sortedBuilder = builder.addSortedBuilder();
        for (int i = 0; i < annotationCount; ++i) {
            ClassDump.dumpTypeAnnotation(parser, sortedBuilder);
        }
    }

    private static void dumpTypeAnnotation(Parser parser, SortedBuilder sortedBuilder) throws IOException {
        int targetType = parser.u1();
        Builder builder = sortedBuilder.addBuilder(String.valueOf(targetType));
        builder.add("target_type: ", targetType);
        switch (targetType) {
            case 0: 
            case 1: {
                builder.add("type_parameter_index: ", parser.u1());
                break;
            }
            case 16: {
                builder.add("supertype_index: ", parser.u2());
                break;
            }
            case 17: 
            case 18: {
                builder.add("type_parameter_index: ", parser.u1());
                builder.add("bound_index: ", parser.u1());
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 22: {
                builder.add("formal_parameter_index: ", parser.u1());
                break;
            }
            case 23: {
                builder.add("throws_type_index: ", parser.u2());
                break;
            }
            case 64: 
            case 65: {
                int tableLength = builder.add("table_length: ", parser.u2());
                for (int i = 0; i < tableLength; ++i) {
                    int startPc = builder.addInsnIndex("start_pc: ", parser.u2());
                    builder.addInsnIndex("length: ", startPc + parser.u2());
                    builder.add("index: ", parser.u2());
                }
                break;
            }
            case 66: {
                builder.add("exception_table_index: ", parser.u2());
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                builder.addInsnIndex("offset: ", parser.u2());
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                builder.addInsnIndex("offset: ", parser.u2());
                builder.add("type_argument_index: ", parser.u1());
                break;
            }
            default: {
                throw new IOException("Unknown target_type: " + targetType);
            }
        }
        ClassDump.dumpTypePath(parser, builder);
        builder.sortByContent();
        ClassDump.dumpAnnotation(parser, builder);
    }

    private static void dumpTypePath(Parser parser, Builder builder) throws IOException {
        int pathLength = builder.add("path_length: ", parser.u1());
        for (int i = 0; i < pathLength; ++i) {
            builder.add("type_path_kind: ", parser.u1());
            builder.add("type_argument_index: ", parser.u1());
        }
    }

    private static void dumpRuntimeInvisibleTypeAnnotationsAttribute(Parser parser, Builder builder) throws IOException {
        ClassDump.dumpRuntimeVisibleTypeAnnotationsAttribute(parser, builder);
    }

    private static void dumpAnnotationDefaultAttribute(Parser parser, Builder builder) throws IOException {
        ClassDump.dumpElementValue(parser, builder);
    }

    private static void dumpBootstrapMethodsAttribute(Parser parser, Builder builder) throws IOException {
        int bootstrapMethodCount = builder.add("num_bootstrap_methods: ", parser.u2());
        for (int i = 0; i < bootstrapMethodCount; ++i) {
            builder.addCpInfo("bootstrap_method_ref: ", parser.u2());
            int bootstrapArgumentCount = builder.add("num_bootstrap_arguments: ", parser.u2());
            for (int j = 0; j < bootstrapArgumentCount; ++j) {
                builder.addCpInfo("bootstrap_argument: ", parser.u2());
            }
        }
    }

    private static void dumpMethodParametersAttribute(Parser parser, Builder builder) throws IOException {
        int parameterCount = builder.add("parameters_count: ", parser.u1());
        for (int i = 0; i < parameterCount; ++i) {
            builder.addCpInfo("name_index: ", parser.u2());
            builder.add("access_flags: ", parser.u2());
        }
    }

    private static void dumpModuleAttribute(Parser parser, Builder builder) throws IOException {
        builder.addCpInfo("name: ", parser.u2());
        builder.add("access: ", parser.u2());
        builder.addCpInfo("version: ", parser.u2());
        int requireCount = builder.add("require_count: ", parser.u2());
        for (int i = 0; i < requireCount; ++i) {
            builder.addCpInfo("name: ", parser.u2());
            builder.add("access: ", parser.u2());
            builder.addCpInfo("version: ", parser.u2());
        }
        int exportCount = builder.add("export_count: ", parser.u2());
        for (int i = 0; i < exportCount; ++i) {
            builder.addCpInfo("name: ", parser.u2());
            builder.add("access: ", parser.u2());
            int exportToCount = builder.add("export_to_count: ", parser.u2());
            for (int j = 0; j < exportToCount; ++j) {
                builder.addCpInfo("to: ", parser.u2());
            }
        }
        int openCount = builder.add("open_count: ", parser.u2());
        for (int i = 0; i < openCount; ++i) {
            builder.addCpInfo("name: ", parser.u2());
            builder.add("access: ", parser.u2());
            int openToCount = builder.add("open_to_count: ", parser.u2());
            for (int j = 0; j < openToCount; ++j) {
                builder.addCpInfo("to: ", parser.u2());
            }
        }
        int useCount = builder.add("use_count: ", parser.u2());
        for (int i = 0; i < useCount; ++i) {
            builder.addCpInfo("use: ", parser.u2());
        }
        int provideCount = builder.add("provide_count: ", parser.u2());
        for (int i = 0; i < provideCount; ++i) {
            builder.addCpInfo("provide: ", parser.u2());
            int provideWithCount = builder.add("provide_with_count: ", parser.u2());
            for (int j = 0; j < provideWithCount; ++j) {
                builder.addCpInfo("with: ", parser.u2());
            }
        }
    }

    private static void dumpModulePackagesAttribute(Parser parser, Builder builder) throws IOException {
        int packageCount = builder.add("package_count: ", parser.u2());
        for (int i = 0; i < packageCount; ++i) {
            builder.addCpInfo("package: ", parser.u2());
        }
    }

    private static void dumpModuleMainClassAttribute(Parser parser, Builder builder) throws IOException {
        builder.addCpInfo("main_class: ", parser.u2());
    }

    private static void dumpNestHostAttribute(Parser parser, Builder builder) throws IOException {
        builder.addCpInfo("host_class: ", parser.u2());
    }

    private static void dumpNestMembersAttribute(Parser parser, Builder builder) throws IOException {
        int numberOfClasses = builder.add("number_of_classes: ", parser.u2());
        for (int i = 0; i < numberOfClasses; ++i) {
            builder.addCpInfo("class: ", parser.u2());
        }
    }

    private static void dumpStackMapAttribute(Parser parser, Builder builder) throws IOException {
        int entryCount = builder.add("number_of_entries: ", parser.u2());
        for (int i = 0; i < entryCount; ++i) {
            builder.addInsnIndex("offset: ", parser.u2());
            int numberOfLocals = builder.add("number_of_locals: ", parser.u2());
            for (int j = 0; j < numberOfLocals; ++j) {
                ClassDump.dumpVerificationTypeInfo(parser, builder);
            }
            int numberOfStackItems = builder.add("number_of_stack_items: ", parser.u2());
            for (int j = 0; j < numberOfStackItems; ++j) {
                ClassDump.dumpVerificationTypeInfo(parser, builder);
            }
        }
    }

    private static class SortedBuilder
    extends AbstractBuilder<Builder> {
        SortedBuilder(Builder parent) {
            super(parent);
        }

        Builder addBuilder(String name) {
            Builder builder = new Builder(name, this);
            this.children.add(builder);
            return builder;
        }

        @Override
        void build(StringBuilder stringBuilder) {
            Collections.sort(this.children);
            super.build(stringBuilder);
        }
    }

    private static class Builder
    extends AbstractBuilder<Object>
    implements Comparable<Builder> {
        private String name;

        Builder(String name, AbstractBuilder<?> parent) {
            super(parent);
            this.name = name;
        }

        <T> T add(String name, T value) {
            this.children.add(name);
            this.children.add(value);
            this.children.add("\n");
            return value;
        }

        int addInsnIndex(String name, int bytecodeOffset) {
            this.add(name, new InstructionIndex(bytecodeOffset, this));
            return bytecodeOffset;
        }

        void addInsn(int insnIndex, int opcode, Object ... arguments) {
            this.children.add(insnIndex);
            this.children.add(": ");
            this.children.add(opcode);
            for (Object argument : arguments) {
                this.children.add(" ");
                this.children.add(argument);
            }
            this.children.add("\n");
        }

        void addCpInfo(String name, int cpIndex) {
            this.add(name, cpIndex == 0 ? Integer.valueOf(0) : this.getCpInfo(cpIndex));
        }

        SortedBuilder addSortedBuilder() {
            SortedBuilder sortedBuilder = new SortedBuilder(this);
            this.children.add(sortedBuilder);
            return sortedBuilder;
        }

        void sortByContent() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object child : this.children) {
                if (child instanceof InstructionIndex) {
                    stringBuilder.append(((InstructionIndex)child).getBytecodeOffset());
                    continue;
                }
                stringBuilder.append(child.toString());
            }
            this.name = stringBuilder.toString();
        }

        @Override
        public int compareTo(Builder builder) {
            return this.name.compareTo(builder.name);
        }

        public boolean equals(Object other) {
            return other instanceof Builder && this.name.equals(((Builder)other).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static abstract class AbstractBuilder<T>
    implements ClassContext,
    MethodContext {
        private static final int CP_INFO_KEY = -268435456;
        private final AbstractBuilder<?> parent;
        final ArrayList<T> children;
        private final HashMap<Integer, Object> context;

        AbstractBuilder(AbstractBuilder<?> parent) {
            this.parent = parent;
            this.children = new ArrayList();
            this.context = new HashMap();
        }

        CpInfo getCpInfo(int cpIndex) {
            return this.getCpInfo(cpIndex, CpInfo.class);
        }

        @Override
        public <C extends CpInfo> C getCpInfo(int cpIndex, Class<C> cpInfoType) {
            Object cpInfo = this.get(0xF0000000 | cpIndex);
            if (cpInfo == null) {
                throw new IllegalArgumentException("Invalid constant pool index: " + cpIndex);
            }
            if (!cpInfoType.isInstance(cpInfo)) {
                throw new IllegalArgumentException("Invalid constant pool type: " + cpInfo.getClass().getName() + " should be " + cpInfoType.getName());
            }
            return (C)((CpInfo)cpInfoType.cast(cpInfo));
        }

        @Override
        public int getInsnIndex(int bytecodeOffset) {
            Integer insnIndex = (Integer)this.get(bytecodeOffset);
            if (insnIndex == null) {
                throw new IllegalArgumentException("Invalid bytecode offset: " + bytecodeOffset);
            }
            return insnIndex;
        }

        void putCpInfo(int cpIndex, CpInfo cpInfo) {
            this.context.put(0xF0000000 | cpIndex, cpInfo);
        }

        void putInsnIndex(int bytecodeOffset, int instructionIndex) {
            this.context.put(bytecodeOffset, instructionIndex);
        }

        void build(StringBuilder stringBuilder) {
            for (T child : this.children) {
                if (child instanceof AbstractBuilder) {
                    ((AbstractBuilder)child).build(stringBuilder);
                    continue;
                }
                stringBuilder.append(child);
            }
        }

        private Object get(int key) {
            Object value = this.context.get(key);
            if (value != null) {
                return value;
            }
            return this.parent == null ? null : super.get(key);
        }
    }

    private static interface MethodContext {
        public int getInsnIndex(int var1);
    }

    private static interface ClassContext {
        public <C extends CpInfo> C getCpInfo(int var1, Class<C> var2);
    }

    private static class Parser {
        private final DataInputStream dataInputStream;

        Parser(byte[] data) {
            this.dataInputStream = new DataInputStream(new ByteArrayInputStream(data));
        }

        int u1() throws IOException {
            return this.dataInputStream.readUnsignedByte();
        }

        int s1() throws IOException {
            return this.dataInputStream.readByte();
        }

        int u2() throws IOException {
            return this.dataInputStream.readUnsignedShort();
        }

        int s2() throws IOException {
            return this.dataInputStream.readShort();
        }

        int u4() throws IOException {
            return this.dataInputStream.readInt();
        }

        long s8() throws IOException {
            long highBytes = this.dataInputStream.readInt();
            long lowBytes = (long)this.dataInputStream.readInt() & 0xFFFFFFFFL;
            return highBytes << 32 | lowBytes;
        }

        String utf8() throws IOException {
            return this.dataInputStream.readUTF();
        }

        byte[] bytes(int length) throws IOException {
            byte[] bytes = new byte[length];
            this.dataInputStream.readFully(bytes);
            return bytes;
        }
    }

    private static class InstructionIndex {
        private final int bytecodeOffset;
        private final MethodContext methodContext;

        InstructionIndex(int bytecodeOffset, MethodContext methodContext) {
            this.bytecodeOffset = bytecodeOffset;
            this.methodContext = methodContext;
        }

        int getBytecodeOffset() {
            return this.bytecodeOffset;
        }

        public String toString() {
            return "<" + this.methodContext.getInsnIndex(this.bytecodeOffset) + ">";
        }
    }

    private static class ConstantDynamicInfo
    extends CpInfo {
        private final int bootstrapMethodAttrIndex;
        private final int nameAndTypeIndex;

        ConstantDynamicInfo(Parser parser, ClassContext classContext) throws IOException {
            super(classContext);
            this.bootstrapMethodAttrIndex = parser.u2();
            this.nameAndTypeIndex = parser.u2();
        }

        @Override
        String dump() {
            return this.bootstrapMethodAttrIndex + "." + this.getCpInfo(this.nameAndTypeIndex, ConstantNameAndTypeInfo.class).dump();
        }
    }

    private static class ConstantPackageInfo
    extends CpInfo {
        private final int descriptorIndex;

        ConstantPackageInfo(Parser parser, ClassContext classContext) throws IOException {
            super(classContext);
            this.descriptorIndex = parser.u2();
        }

        @Override
        String dump() {
            return this.getCpInfo(this.descriptorIndex, ConstantUtf8Info.class).dump();
        }
    }

    private static class ConstantModuleInfo
    extends CpInfo {
        private final int descriptorIndex;

        ConstantModuleInfo(Parser parser, ClassContext classContext) throws IOException {
            super(classContext);
            this.descriptorIndex = parser.u2();
        }

        @Override
        String dump() {
            return this.getCpInfo(this.descriptorIndex, ConstantUtf8Info.class).dump();
        }
    }

    private static class ConstantInvokeDynamicInfo
    extends CpInfo {
        private final int bootstrapMethodAttrIndex;
        private final int nameAndTypeIndex;

        ConstantInvokeDynamicInfo(Parser parser, ClassContext classContext) throws IOException {
            super(classContext);
            this.bootstrapMethodAttrIndex = parser.u2();
            this.nameAndTypeIndex = parser.u2();
        }

        @Override
        String dump() {
            return this.bootstrapMethodAttrIndex + "." + this.getCpInfo(this.nameAndTypeIndex, ConstantNameAndTypeInfo.class).dump();
        }
    }

    private static class ConstantMethodTypeInfo
    extends CpInfo {
        private final int descriptorIndex;

        ConstantMethodTypeInfo(Parser parser, ClassContext classContext) throws IOException {
            super(classContext);
            this.descriptorIndex = parser.u2();
        }

        @Override
        String dump() {
            return this.getCpInfo(this.descriptorIndex, ConstantUtf8Info.class).dump();
        }
    }

    private static class ConstantMethodHandleInfo
    extends CpInfo {
        private final int referenceKind;
        private final int referenceIndex;

        ConstantMethodHandleInfo(Parser parser, ClassContext classContext) throws IOException {
            super(classContext);
            this.referenceKind = parser.u1();
            this.referenceIndex = parser.u2();
        }

        @Override
        String dump() {
            return this.referenceKind + "." + this.getCpInfo(this.referenceIndex, CpInfo.class);
        }
    }

    private static class ConstantUtf8Info
    extends CpInfo {
        ConstantUtf8Info(Parser parser) throws IOException {
            super(parser.utf8());
        }
    }

    private static class ConstantNameAndTypeInfo
    extends CpInfo {
        private final int nameIndex;
        private final int descriptorIndex;

        ConstantNameAndTypeInfo(Parser parser, ClassContext classContext) throws IOException {
            super(classContext);
            this.nameIndex = parser.u2();
            this.descriptorIndex = parser.u2();
        }

        @Override
        String dump() {
            return this.getCpInfo(this.nameIndex, ConstantUtf8Info.class).dump() + this.getCpInfo(this.descriptorIndex, ConstantUtf8Info.class).dump();
        }
    }

    private static class ConstantDoubleInfo
    extends CpInfo {
        ConstantDoubleInfo(Parser parser) throws IOException {
            super(Double.toString(Double.longBitsToDouble(parser.s8())));
        }

        @Override
        int size() {
            return 2;
        }
    }

    private static class ConstantLongInfo
    extends CpInfo {
        ConstantLongInfo(Parser parser) throws IOException {
            super(Long.toString(parser.s8()));
        }

        @Override
        int size() {
            return 2;
        }
    }

    private static class ConstantFloatInfo
    extends CpInfo {
        ConstantFloatInfo(Parser parser) throws IOException {
            super(Float.toString(Float.intBitsToFloat(parser.u4())));
        }
    }

    private static class ConstantIntegerInfo
    extends CpInfo {
        ConstantIntegerInfo(Parser parser) throws IOException {
            super(Integer.toString(parser.u4()));
        }
    }

    private static class ConstantStringInfo
    extends CpInfo {
        final int stringIndex;

        ConstantStringInfo(Parser parser, ClassContext classContext) throws IOException {
            super(classContext);
            this.stringIndex = parser.u2();
        }

        @Override
        String dump() {
            return this.getCpInfo(this.stringIndex, ConstantUtf8Info.class).dump();
        }
    }

    private static class ConstantInterfaceMethodRefInfo
    extends CpInfo {
        private final int classIndex;
        private final int nameAndTypeIndex;

        ConstantInterfaceMethodRefInfo(Parser parser, ClassContext classContext) throws IOException {
            super(classContext);
            this.classIndex = parser.u2();
            this.nameAndTypeIndex = parser.u2();
        }

        @Override
        String dump() {
            return this.getCpInfo(this.classIndex, ConstantClassInfo.class).dump() + "." + this.getCpInfo(this.nameAndTypeIndex, ConstantNameAndTypeInfo.class).dump();
        }
    }

    private static class ConstantMethodRefInfo
    extends CpInfo {
        private final int classIndex;
        private final int nameAndTypeIndex;

        ConstantMethodRefInfo(Parser parser, ClassContext classContext) throws IOException {
            super(classContext);
            this.classIndex = parser.u2();
            this.nameAndTypeIndex = parser.u2();
        }

        @Override
        String dump() {
            return this.getCpInfo(this.classIndex, ConstantClassInfo.class).dump() + "." + this.getCpInfo(this.nameAndTypeIndex, ConstantNameAndTypeInfo.class).dump();
        }
    }

    private static class ConstantFieldRefInfo
    extends CpInfo {
        private final int classIndex;
        private final int nameAndTypeIndex;

        ConstantFieldRefInfo(Parser parser, ClassContext classContext) throws IOException {
            super(classContext);
            this.classIndex = parser.u2();
            this.nameAndTypeIndex = parser.u2();
        }

        @Override
        String dump() {
            return this.getCpInfo(this.classIndex, ConstantClassInfo.class).dump() + "." + this.getCpInfo(this.nameAndTypeIndex, ConstantNameAndTypeInfo.class).dump();
        }
    }

    private static class ConstantClassInfo
    extends CpInfo {
        private final int nameIndex;

        ConstantClassInfo(Parser parser, ClassContext classContext) throws IOException {
            super(classContext);
            this.nameIndex = parser.u2();
        }

        @Override
        String dump() {
            return this.getCpInfo(this.nameIndex, ConstantUtf8Info.class).dump();
        }
    }

    private static abstract class CpInfo {
        private String dump;
        private final ClassContext classContext;

        CpInfo(String dump) {
            this.dump = dump;
            this.classContext = null;
        }

        CpInfo(ClassContext classContext) {
            this.classContext = classContext;
        }

        int size() {
            return 1;
        }

        <C extends CpInfo> C getCpInfo(int cpIndex, Class<C> cpInfoType) {
            return this.classContext.getCpInfo(cpIndex, cpInfoType);
        }

        String dump() {
            return this.dump;
        }

        public String toString() {
            if (this.dump == null) {
                this.dump = this.getClass().getSimpleName() + " " + this.dump();
            }
            return this.dump;
        }
    }
}

