/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.stream.Stream;
import org.junit.jupiter.params.provider.Arguments;
import org.objectweb.asm.test.ClassFormatException;
import org.objectweb.asm.test.Util;

public abstract class AsmTest {
    private static final int INPUT_STREAM_DATA_CHUNK_SIZE = 4096;
    public static final String ALL_CLASSES_AND_ALL_APIS = "allClassesAndAllApis";
    public static final String ALL_CLASSES_AND_LATEST_API = "allClassesAndLatestApi";
    public static final String UNSUPPORTED_OPERATION_MESSAGE_PATTERN = ".* requires ASM[56789].*";

    public static Stream<Arguments> allClassesAndAllApis() {
        return AsmTest.classesAndApis(Api.values());
    }

    public static Stream<Arguments> allClassesAndLatestApi() {
        return AsmTest.classesAndApis(Api.ASM9);
    }

    private static Stream<Arguments> classesAndApis(Api ... apis) {
        return Arrays.stream(PrecompiledClass.values()).flatMap(precompiledClass -> Arrays.stream(apis).map(api -> Arguments.of((Object[])new Object[]{precompiledClass, api})));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getBytes(String name) {
        String resourceName = name.replace('.', '/') + ".class";
        try (InputStream inputStream = ClassLoader.getSystemResourceAsStream(resourceName);){
            int bytesRead;
            if (inputStream == null) {
                throw new IllegalArgumentException("Class not found " + name);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] data = new byte[4096];
            while ((bytesRead = inputStream.read(data, 0, data.length)) != -1) {
                outputStream.write(data, 0, bytesRead);
            }
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new ClassFormatException("Can't read " + name, e);
        }
    }

    public static enum Api {
        ASM4("ASM4", 262144),
        ASM5("ASM5", 327680),
        ASM6("ASM6", 393216),
        ASM7("ASM7", 458752),
        ASM8("ASM8", 524288),
        ASM9("ASM9", 0x1090000);

        private final String name;
        private final int value;

        private Api(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum InvalidClass {
        INVALID_BYTECODE_OFFSET("invalid.InvalidBytecodeOffset"),
        INVALID_CLASS_VERSION("invalid.InvalidClassVersion"),
        INVALID_CONSTANT_POOL_INDEX("invalid.InvalidConstantPoolIndex"),
        INVALID_CONSTANT_POOL_REFERENCE("invalid.InvalidConstantPoolReference"),
        INVALID_CP_INFO_TAG("invalid.InvalidCpInfoTag"),
        INVALID_ELEMENT_VALUE("invalid.InvalidElementValue"),
        INVALID_INSN_TYPE_ANNOTATION_TARGET_TYPE("invalid.InvalidInsnTypeAnnotationTargetType"),
        INVALID_OPCODE("invalid.InvalidOpcode"),
        INVALID_STACK_MAP_FRAME_TYPE("invalid.InvalidStackMapFrameType"),
        INVALID_TYPE_ANNOTATION_TARGET_TYPE("invalid.InvalidTypeAnnotationTargetType"),
        INVALID_VERIFICATION_TYPE_INFO("invalid.InvalidVerificationTypeInfo"),
        INVALID_WIDE_OPCODE("invalid.InvalidWideOpcode");

        private final String name;

        private InvalidClass(String name) {
            this.name = name;
        }

        public byte[] getBytes() {
            return AsmTest.getBytes(this.name);
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum PrecompiledClass {
        DEFAULT_PACKAGE("DefaultPackage"),
        JDK3_ALL_INSTRUCTIONS("jdk3.AllInstructions"),
        JDK3_ALL_STRUCTURES("jdk3.AllStructures"),
        JDK3_ANONYMOUS_INNER_CLASS("jdk3.AllStructures$1"),
        JDK3_ARTIFICIAL_STRUCTURES("jdk3.ArtificialStructures"),
        JDK3_INNER_CLASS("jdk3.AllStructures$InnerClass"),
        JDK3_LARGE_METHOD("jdk3.LargeMethod"),
        JDK5_ALL_INSTRUCTIONS("jdk5.AllInstructions"),
        JDK5_ALL_STRUCTURES("jdk5.AllStructures"),
        JDK5_ANNOTATION("jdk5.AllStructures$InvisibleAnnotation"),
        JDK5_ENUM("jdk5.AllStructures$EnumClass"),
        JDK5_LOCAL_CLASS("jdk5.AllStructures$1LocalClass"),
        JDK8_ALL_FRAMES("jdk8.AllFrames"),
        JDK8_ALL_INSTRUCTIONS("jdk8.AllInstructions"),
        JDK8_ALL_STRUCTURES("jdk8.AllStructures"),
        JDK8_ANONYMOUS_INNER_CLASS("jdk8.AllStructures$1"),
        JDK8_ARTIFICIAL_STRUCTURES("jdk8.Artificial$()$Structures"),
        JDK8_INNER_CLASS("jdk8.AllStructures$InnerClass"),
        JDK8_LARGE_METHOD("jdk8.LargeMethod"),
        JDK9_MODULE("jdk9.module-info"),
        JDK11_ALL_INSTRUCTIONS("jdk11.AllInstructions"),
        JDK11_ALL_STRUCTURES("jdk11.AllStructures"),
        JDK11_ALL_STRUCTURES_NESTED("jdk11.AllStructures$Nested"),
        JDK14_ALL_STRUCTURES_RECORD("jdk14.AllStructures$RecordSubType"),
        JDK14_ALL_STRUCTURES_EMPTY_RECORD("jdk14.AllStructures$EmptyRecord"),
        JDK15_ALL_STRUCTURES("jdk15.AllStructures");

        private final String name;
        private byte[] bytes;

        private PrecompiledClass(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getInternalName() {
            return this.name.endsWith("module-info") ? "module-info" : this.name.replace('.', '/');
        }

        public boolean isMoreRecentThan(Api api) {
            if (this.name.startsWith("jdk8.") && api.value() < Api.ASM5.value()) {
                return true;
            }
            if (this.name.startsWith("jdk9.") && api.value() < Api.ASM6.value()) {
                return true;
            }
            if (this.name.startsWith("jdk11.") && api.value() < Api.ASM7.value()) {
                return true;
            }
            if (this.name.startsWith("jdk14.") && api.value() < Api.ASM8.value()) {
                return true;
            }
            return this.name.startsWith("jdk15.") && api.value() < Api.ASM9.value();
        }

        public boolean isMoreRecentThanCurrentJdk() {
            if (this.name.startsWith("jdk9.")) {
                return Util.getMajorJavaVersion() < 9;
            }
            if (this.name.startsWith("jdk11.")) {
                return Util.getMajorJavaVersion() < 11;
            }
            if (this.name.startsWith("jdk14.")) {
                return Util.getMajorJavaVersion() < 14;
            }
            if (this.name.startsWith("jdk15.")) {
                return Util.getMajorJavaVersion() < 15;
            }
            return false;
        }

        public byte[] getBytes() {
            if (this.bytes == null) {
                this.bytes = AsmTest.getBytes(this.name);
            }
            return (byte[])this.bytes.clone();
        }

        public String toString() {
            return this.name;
        }
    }
}

