/***
 * ASM: a very small and fast Java bytecode manipulation framework
 * Copyright (c) 2000-2011 INRIA, France Telecom
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.objectweb.asm.tree.signature;

import java.util.List;

import org.objectweb.asm.signature.SignatureVisitor;

public class TypeSignatureFactory extends SignatureVisitor {

    Object target;

    private TypeSignature value;

    public TypeSignatureFactory(final int api) {
        super(api);
    }

    TypeSignatureFactory(final int api, final Object target) {
        super(api);
        this.target = target;
    }

    @Override
    public void visitBaseType(final char descriptor) {
        if (descriptor != 'V') {
            value = new PrimitiveType(api);
            value.visitBaseType(descriptor);
        }
        storeValue();
    }

    @Override
    public void visitTypeVariable(final String name) {
        value = new TypeVariable(api);
        value.visitTypeVariable(name);
        storeValue();
    }

    @Override
    public SignatureVisitor visitArrayType() {
        value = new ArrayType(api);
        storeValue();
        return value;
    }

    @Override
    public void visitClassType(final String name) {
        value = new ClassType(api);
        value.visitClassType(name);
        storeValue();
    }

    @Override
    public void visitInnerClassType(final String name) {
        value.visitInnerClassType(name);
    }

    @Override
    public void visitTypeArgument() {
        value.visitTypeArgument();
    }

    @Override
    public SignatureVisitor visitTypeArgument(final char wildcard) {
        return value.visitTypeArgument(wildcard);
    }

    public TypeSignature getValue() {
        return value;
    }

    private void storeValue() {
        if (target == null) {
            return;
        }
        if (target instanceof List<?>) {
            ((List<TypeSignature>) target).add(value);
        } else if (target instanceof ClassSignature) {
            ((ClassSignature) target).superClass = value;
        } else if (target instanceof MethodSignature) {
            ((MethodSignature) target).result = value;
        } else if (target instanceof TypeArgument) {
            ((TypeArgument) target).bound = value;
        } else if (target instanceof TypeParameter) {
            ((TypeParameter) target).classBound = value;
        }
    }
}
