/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.testng4osgi.inject;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.inject.Inject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGInject {
    private static final Log LOGGER = LogFactory.getLog(TestNGInject.class);
    private BundleContext bundleContext;

    public TestNGInject(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected Object getValue(String name, Class<?> analyzedClass, Class<?> searchedClass) {
        Object service;
        if (BundleContext.class.equals(searchedClass)) {
            return this.bundleContext;
        }
        ServiceReference serviceReference = this.bundleContext.getServiceReference(searchedClass);
        if (serviceReference != null && (service = this.bundleContext.getService(serviceReference)) != null) {
            return service;
        }
        throw new IllegalStateException("Unable to find value for the '" + name + "' field/setter with the searched class '" + searchedClass + "' in the analyzed class '" + analyzedClass + "'.");
    }

    public Object inject(Object instance) {
        Method[] methods;
        if (instance == null) {
            return instance;
        }
        Field[] fields = instance.getClass().getDeclaredFields();
        if (fields != null) {
            for (Field field : fields) {
                Inject inject = field.getAnnotation(Inject.class);
                if (inject == null) continue;
                boolean isAccessible = field.isAccessible();
                try {
                    field.setAccessible(true);
                    Object value = this.getValue(field.getName(), instance.getClass(), field.getType());
                    LOGGER.debug((Object)"Injecting value ''{0}'' in field ''{1}''", new Object[]{value, field});
                    if (value == null) continue;
                    field.set(instance, value);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Cannot inject field", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Cannot inject field", e);
                }
                finally {
                    field.setAccessible(isAccessible);
                }
            }
        }
        if ((methods = instance.getClass().getDeclaredMethods()) != null) {
            for (Method method : methods) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes == null || parameterTypes.length != 1) continue;
                Class<?> parameterType = parameterTypes[0];
                Inject inject = method.getAnnotation(Inject.class);
                if (inject == null) continue;
                boolean isAccessible = method.isAccessible();
                try {
                    method.setAccessible(true);
                    Object value = this.getValue(method.getName(), instance.getClass(), parameterType);
                    LOGGER.debug((Object)"Injecting value ''{0}'' in field ''{1}''", new Object[]{value, method});
                    if (value == null) continue;
                    method.invoke(instance, value);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Cannot inject method", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Cannot inject method", e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException("Cannot inject method", e);
                }
                finally {
                    method.setAccessible(isAccessible);
                }
            }
        }
        return instance;
    }
}

