/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.testng4osgi.launcher;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.maven.osgi.launcher.test.api.ITestConfiguration;
import org.ow2.util.maven.osgi.launcher.test.api.ITestLauncher;
import org.ow2.util.maven.osgi.launcher.test.api.ITestReport;
import org.ow2.util.testng4osgi.factory.TestNGObjectFactory;
import org.ow2.util.testng4osgi.launcher.EnhancedTestNG;
import org.ow2.util.testng4osgi.launcher.TestReport;
import org.ow2.util.testng4osgi.listener.TestNGTestListener;
import org.testng.ITestObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGLauncher
implements ITestLauncher {
    private static final Log LOGGER = LogFactory.getLog(TestNGLauncher.class);
    private Map<BundleContext, EnhancedTestNG> testNGs = new HashMap<BundleContext, EnhancedTestNG>();
    private TestNGTestListener reportListener = new TestNGTestListener();

    public void addTests(BundleContext bundleContext, List<Class<?>> classes) {
        EnhancedTestNG testNG = new EnhancedTestNG(bundleContext);
        testNG.setOSGiClasses(classes);
        testNG.setObjectFactory((ITestObjectFactory)new TestNGObjectFactory(bundleContext));
        testNG.addListener(this.reportListener);
        this.testNGs.put(bundleContext, testNG);
    }

    public ITestReport runTests(ITestConfiguration configuration) {
        for (EnhancedTestNG testNG : this.testNGs.values()) {
            if (configuration.getOutputDirectory() == null) continue;
            testNG.setOutputDirectory(configuration.getOutputDirectory().getAbsolutePath());
        }
        for (EnhancedTestNG testNG : this.testNGs.values()) {
            testNG.run();
        }
        int status = 0;
        for (EnhancedTestNG testNG : this.testNGs.values()) {
            status |= testNG.getStatus();
        }
        LOGGER.info((Object)"Report : Run ''{0}'', Failures : ''{1}'', Skipped : ''{2}'', Success : ''{3}''", new Object[]{this.reportListener.getTestStart(), this.reportListener.getFailures(), this.reportListener.getSkipped(), this.reportListener.getTestStart(), this.reportListener.getTestSuccess()});
        return new TestReport(0 == status);
    }
}

