/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.testng4osgi.tracker;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.testng4osgi.launcher.TestNGLauncher;

public class TestNGBundleTracker
implements BundleTrackerCustomizer {
    private static final String TESTNG_ANNOTATION_PACKAGE = "org.testng.annotations";
    private static final Log LOGGER = LogFactory.getLog(TestNGBundleTracker.class);
    private TestNGLauncher testNGLauncher;

    public TestNGBundleTracker(TestNGLauncher testNGLauncher) {
        this.testNGLauncher = testNGLauncher;
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        List importPackages = bundleWiring.getRequiredWires("osgi.wiring.package");
        if (importPackages == null) {
            return null;
        }
        boolean found = false;
        for (int i = 0; !found && i < importPackages.size(); ++i) {
            Object packageName;
            Map attributes;
            BundleWire bundleWire = (BundleWire)importPackages.get(i);
            BundleCapability bundleCapability = bundleWire.getCapability();
            if (bundleCapability == null || (attributes = bundleCapability.getAttributes()) == null || !TESTNG_ANNOTATION_PACKAGE.equals(packageName = attributes.get("osgi.wiring.package"))) continue;
            found = true;
        }
        if (!found) {
            return null;
        }
        LOGGER.debug((Object)"The TestNG import has been found in the bundle ''{0}'' with id ''{1}''", new Object[]{bundle.getSymbolicName(), bundle.getBundleId()});
        List classEntriesURL = bundleWiring.findEntries("/", "*.class", 1);
        if (classEntriesURL == null) {
            return null;
        }
        ArrayList classes = new ArrayList();
        for (URL url : classEntriesURL) {
            String path = url.getPath();
            String className = null;
            if (path != null) {
                className = path.substring(1).replace("/", ".");
                if (className.endsWith(".class")) {
                    className = className.substring(0, className.length() - 6);
                } else {
                    LOGGER.warn((Object)"Invalid class named ''{0}''", new Object[]{className});
                    className = null;
                }
            }
            if (className == null) continue;
            try {
                Class<?> clazz = bundleWiring.getClassLoader().loadClass(className);
                classes.add(clazz);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error((Object)"Unable to load class ''{0}''", new Object[]{className, e});
            }
        }
        if (!classes.isEmpty()) {
            LOGGER.debug((Object)"classes = {0}", new Object[]{classes});
            this.testNGLauncher.addTests(bundle.getBundleContext(), classes);
        }
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
    }
}

