/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.hamcrest.Matcher;
import org.hamcrest.beans.HasProperty;
import org.hamcrest.beans.HasPropertyWithValue;
import org.hamcrest.beans.SamePropertyValuesAs;
import org.hamcrest.collection.IsArray;
import org.hamcrest.collection.IsArrayContaining;
import org.hamcrest.collection.IsArrayContainingInAnyOrder;
import org.hamcrest.collection.IsArrayContainingInOrder;
import org.hamcrest.collection.IsArrayWithSize;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.collection.IsEmptyIterable;
import org.hamcrest.collection.IsIn;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.hamcrest.collection.IsIterableWithSize;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.collection.IsMapContainingKey;
import org.hamcrest.collection.IsMapContainingValue;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.AnyOf;
import org.hamcrest.core.CombinableMatcher;
import org.hamcrest.core.DescribedAs;
import org.hamcrest.core.Every;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsAnything;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.hamcrest.core.StringContains;
import org.hamcrest.core.StringEndsWith;
import org.hamcrest.core.StringStartsWith;
import org.hamcrest.number.IsCloseTo;
import org.hamcrest.number.OrderingComparison;
import org.hamcrest.object.HasToString;
import org.hamcrest.object.IsCompatibleType;
import org.hamcrest.object.IsEventFrom;
import org.hamcrest.text.IsEqualIgnoringCase;
import org.hamcrest.text.IsEqualIgnoringWhiteSpace;
import org.hamcrest.xml.HasXPath;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Matchers {
    public static <T> Matcher<T> allOf(Matcher<T> first, Matcher<? super T> second, Matcher<? super T> third, Matcher<? super T> fourth, Matcher<? super T> fifth, Matcher<? super T> sixth) {
        return AllOf.allOf(first, second, third, fourth, fifth, sixth);
    }

    public static <T> Matcher<T> allOf(Matcher<T> first, Matcher<? super T> second, Matcher<? super T> third, Matcher<? super T> fourth) {
        return AllOf.allOf(first, second, third, fourth);
    }

    public static <T> Matcher<T> allOf(Matcher<T> first, Matcher<? super T> second, Matcher<? super T> third, Matcher<? super T> fourth, Matcher<? super T> fifth) {
        return AllOf.allOf(first, second, third, fourth, fifth);
    }

    public static <T> Matcher<T> allOf(Iterable<Matcher<? super T>> matchers) {
        return AllOf.allOf(matchers);
    }

    public static <T> Matcher<T> allOf(Matcher<? super T> ... matchers) {
        return AllOf.allOf(matchers);
    }

    public static <T> Matcher<T> allOf(Matcher<T> first, Matcher<? super T> second) {
        return AllOf.allOf(first, second);
    }

    public static <T> Matcher<T> allOf(Matcher<T> first, Matcher<? super T> second, Matcher<? super T> third) {
        return AllOf.allOf(first, second, third);
    }

    public static <T> AnyOf<T> anyOf(Matcher<T> first, Matcher<? super T> second, Matcher<? super T> third, Matcher<? super T> fourth, Matcher<? super T> fifth, Matcher<? super T> sixth) {
        return AnyOf.anyOf(first, second, third, fourth, fifth, sixth);
    }

    public static <T> AnyOf<T> anyOf(Matcher<T> first, Matcher<? super T> second, Matcher<? super T> third, Matcher<? super T> fourth) {
        return AnyOf.anyOf(first, second, third, fourth);
    }

    public static <T> AnyOf<T> anyOf(Matcher<T> first, Matcher<? super T> second, Matcher<? super T> third, Matcher<? super T> fourth, Matcher<? super T> fifth) {
        return AnyOf.anyOf(first, second, third, fourth, fifth);
    }

    public static <T> AnyOf<T> anyOf(Iterable<Matcher<? super T>> matchers) {
        return AnyOf.anyOf(matchers);
    }

    public static <T> AnyOf<T> anyOf(Matcher<? super T> ... matchers) {
        return AnyOf.anyOf(matchers);
    }

    public static <T> AnyOf<T> anyOf(Matcher<T> first, Matcher<? super T> second) {
        return AnyOf.anyOf(first, second);
    }

    public static <T> AnyOf<T> anyOf(Matcher<T> first, Matcher<? super T> second, Matcher<? super T> third) {
        return AnyOf.anyOf(first, second, third);
    }

    public static <LHS> CombinableMatcher<LHS> both(Matcher<? super LHS> matcher) {
        return CombinableMatcher.both(matcher);
    }

    public static <LHS> CombinableMatcher<LHS> either(Matcher<? super LHS> matcher) {
        return CombinableMatcher.either(matcher);
    }

    public static <T> Matcher<T> describedAs(String description, Matcher<T> matcher, Object ... values) {
        return DescribedAs.describedAs(description, matcher, values);
    }

    public static <U> Matcher<Iterable<U>> everyItem(Matcher<U> itemMatcher) {
        return Every.everyItem(itemMatcher);
    }

    public static <T> Matcher<T> is(Matcher<T> matcher) {
        return Is.is(matcher);
    }

    public static <T> Matcher<? super T> is(T value) {
        return Is.is(value);
    }

    public static <T> Matcher<? super T> is(Class<T> type) {
        return Is.is(type);
    }

    public static <T> Matcher<T> anything() {
        return IsAnything.anything();
    }

    public static <T> Matcher<T> anything(String description) {
        return IsAnything.anything(description);
    }

    public static <T> Matcher<Iterable<? super T>> hasItem(T element) {
        return IsCollectionContaining.hasItem(element);
    }

    public static <T> Matcher<Iterable<? super T>> hasItem(Matcher<? super T> elementMatcher) {
        return IsCollectionContaining.hasItem(elementMatcher);
    }

    public static <T> Matcher<Iterable<T>> hasItems(Matcher<? super T> ... elementMatchers) {
        return IsCollectionContaining.hasItems(elementMatchers);
    }

    public static <T> Matcher<Iterable<T>> hasItems(T ... elements) {
        return IsCollectionContaining.hasItems(elements);
    }

    public static <T> Matcher<? super T> equalTo(T operand) {
        return IsEqual.equalTo(operand);
    }

    public static <T> Matcher<T> instanceOf(Class<?> type) {
        return IsInstanceOf.instanceOf(type);
    }

    public static <T> Matcher<T> any(Class<T> type) {
        return IsInstanceOf.any(type);
    }

    public static <T> Matcher<T> not(Matcher<T> matcher) {
        return IsNot.not(matcher);
    }

    public static <T> Matcher<? super T> not(T value) {
        return IsNot.not(value);
    }

    public static <T> Matcher<T> nullValue() {
        return IsNull.nullValue();
    }

    public static <T> Matcher<T> nullValue(Class<T> type) {
        return IsNull.nullValue(type);
    }

    public static <T> Matcher<T> notNullValue() {
        return IsNull.notNullValue();
    }

    public static <T> Matcher<T> notNullValue(Class<T> type) {
        return IsNull.notNullValue(type);
    }

    public static <T> Matcher<T> sameInstance(T object) {
        return IsSame.sameInstance(object);
    }

    public static Matcher<String> containsString(String substring) {
        return StringContains.containsString(substring);
    }

    public static Matcher<String> startsWith(String substring) {
        return StringStartsWith.startsWith(substring);
    }

    public static Matcher<String> endsWith(String substring) {
        return StringEndsWith.endsWith(substring);
    }

    public static <T> IsArray<T> array(Matcher<? super T> ... elementMatchers) {
        return IsArray.array(elementMatchers);
    }

    public static <T> Matcher<T[]> hasItemInArray(Matcher<? super T> elementMatcher) {
        return IsArrayContaining.hasItemInArray(elementMatcher);
    }

    public static <T> Matcher<T[]> hasItemInArray(T element) {
        return IsArrayContaining.hasItemInArray(element);
    }

    public static <E> Matcher<E[]> arrayContaining(E ... items) {
        return IsArrayContainingInOrder.arrayContaining(items);
    }

    public static <E> Matcher<E[]> arrayContaining(Matcher<? super E> ... matchers) {
        return IsArrayContainingInOrder.arrayContaining(matchers);
    }

    public static <E> Matcher<E[]> arrayContaining(List<Matcher<? super E>> matchers) {
        return IsArrayContainingInOrder.arrayContaining(matchers);
    }

    public static <E> Matcher<E[]> arrayContainingInAnyOrder(Matcher<? super E> ... matchers) {
        return IsArrayContainingInAnyOrder.arrayContainingInAnyOrder(matchers);
    }

    public static <E> Matcher<E[]> arrayContainingInAnyOrder(Collection<Matcher<? super E>> matchers) {
        return IsArrayContainingInAnyOrder.arrayContainingInAnyOrder(matchers);
    }

    public static <E> Matcher<E[]> arrayContainingInAnyOrder(E ... items) {
        return IsArrayContainingInAnyOrder.arrayContainingInAnyOrder(items);
    }

    public static <E> Matcher<E[]> arrayWithSize(Matcher<? super Integer> sizeMatcher) {
        return IsArrayWithSize.arrayWithSize(sizeMatcher);
    }

    public static <E> Matcher<E[]> arrayWithSize(int size) {
        return IsArrayWithSize.arrayWithSize(size);
    }

    public static <E> Matcher<E[]> emptyArray() {
        return IsArrayWithSize.emptyArray();
    }

    public static <E> Matcher<? super Collection<? extends E>> hasSize(Matcher<? super Integer> size) {
        return IsCollectionWithSize.hasSize(size);
    }

    public static <E> Matcher<? super Collection<? extends E>> hasSize(int size) {
        return IsCollectionWithSize.hasSize(size);
    }

    public static <E> Matcher<Collection<E>> empty() {
        return IsEmptyCollection.empty();
    }

    public static <E> Matcher<Iterable<E>> emptyIterable() {
        return IsEmptyIterable.emptyIterable();
    }

    public static <E> Matcher<Iterable<E>> contains(Matcher<E> item) {
        return IsIterableContainingInOrder.contains(item);
    }

    public static <E> Matcher<Iterable<E>> contains(Matcher<? super E> ... item) {
        return IsIterableContainingInOrder.contains(item);
    }

    public static <E> Matcher<Iterable<E>> contains(List<Matcher<? super E>> contents) {
        return IsIterableContainingInOrder.contains(contents);
    }

    public static <E> Matcher<Iterable<E>> contains(E ... items) {
        return IsIterableContainingInOrder.contains(items);
    }

    public static <T> Matcher<Iterable<T>> containsInAnyOrder(Collection<Matcher<? super T>> matchers) {
        return IsIterableContainingInAnyOrder.containsInAnyOrder(matchers);
    }

    public static <T> Matcher<Iterable<T>> containsInAnyOrder(Matcher<? super T> ... item) {
        return IsIterableContainingInAnyOrder.containsInAnyOrder(item);
    }

    public static <E> Matcher<Iterable<E>> containsInAnyOrder(Matcher<E> item) {
        return IsIterableContainingInAnyOrder.containsInAnyOrder(item);
    }

    public static <T> Matcher<Iterable<T>> containsInAnyOrder(T ... items) {
        return IsIterableContainingInAnyOrder.containsInAnyOrder(items);
    }

    public static <E> Matcher<Iterable<E>> iterableWithSize(Matcher<? super Integer> sizeMatcher) {
        return IsIterableWithSize.iterableWithSize(sizeMatcher);
    }

    public static <E> Matcher<Iterable<E>> iterableWithSize(int size) {
        return IsIterableWithSize.iterableWithSize(size);
    }

    public static <K, V> Matcher<Map<? extends K, ? extends V>> hasEntry(Matcher<? super K> keyMatcher, Matcher<? super V> valueMatcher) {
        return IsMapContaining.hasEntry(keyMatcher, valueMatcher);
    }

    public static <K, V> Matcher<Map<? extends K, ? extends V>> hasEntry(K key, V value) {
        return IsMapContaining.hasEntry(key, value);
    }

    public static <K> Matcher<Map<? super K, ?>> hasKey(K key) {
        return IsMapContainingKey.hasKey(key);
    }

    public static <K> Matcher<Map<? super K, ?>> hasKey(Matcher<? super K> keyMatcher) {
        return IsMapContainingKey.hasKey(keyMatcher);
    }

    public static <V> Matcher<? super Map<?, V>> hasValue(V value) {
        return IsMapContainingValue.hasValue(value);
    }

    public static <V> Matcher<? super Map<?, V>> hasValue(Matcher<? super V> valueMatcher) {
        return IsMapContainingValue.hasValue(valueMatcher);
    }

    public static <T> Matcher<T> isIn(Collection<T> collection) {
        return IsIn.isIn(collection);
    }

    public static <T> Matcher<T> isIn(T[] param1) {
        return IsIn.isIn(param1);
    }

    public static <T> Matcher<T> isOneOf(T ... elements) {
        return IsIn.isOneOf(elements);
    }

    public static Matcher<Double> closeTo(double operand, double error) {
        return IsCloseTo.closeTo(operand, error);
    }

    public static <T extends Comparable<T>> Matcher<? super T> comparesEqualTo(T value) {
        return OrderingComparison.comparesEqualTo(value);
    }

    public static <T extends Comparable<T>> Matcher<? super T> greaterThan(T value) {
        return OrderingComparison.greaterThan(value);
    }

    public static <T extends Comparable<T>> Matcher<? super T> greaterThanOrEqualTo(T value) {
        return OrderingComparison.greaterThanOrEqualTo(value);
    }

    public static <T extends Comparable<T>> Matcher<? super T> lessThan(T value) {
        return OrderingComparison.lessThan(value);
    }

    public static <T extends Comparable<T>> Matcher<? super T> lessThanOrEqualTo(T value) {
        return OrderingComparison.lessThanOrEqualTo(value);
    }

    public static Matcher<String> equalToIgnoringCase(String string) {
        return IsEqualIgnoringCase.equalToIgnoringCase(string);
    }

    public static Matcher<String> equalToIgnoringWhiteSpace(String string) {
        return IsEqualIgnoringWhiteSpace.equalToIgnoringWhiteSpace(string);
    }

    public static <T> Matcher<T> hasToString(Matcher<? super String> toStringMatcher) {
        return HasToString.hasToString(toStringMatcher);
    }

    public static <T> Matcher<T> hasToString(String expectedToString) {
        return HasToString.hasToString(expectedToString);
    }

    public static <T> Matcher<Class<?>> typeCompatibleWith(Class<T> baseType) {
        return IsCompatibleType.typeCompatibleWith(baseType);
    }

    public static Matcher<EventObject> eventFrom(Class<? extends EventObject> eventClass, Object source) {
        return IsEventFrom.eventFrom(eventClass, source);
    }

    public static Matcher<EventObject> eventFrom(Object source) {
        return IsEventFrom.eventFrom(source);
    }

    public static <T> Matcher<T> hasProperty(String propertyName) {
        return HasProperty.hasProperty(propertyName);
    }

    public static <T> Matcher<T> hasProperty(String propertyName, Matcher<?> value) {
        return HasPropertyWithValue.hasProperty(propertyName, value);
    }

    public static <T> Matcher<T> samePropertyValuesAs(T expectedBean) {
        return SamePropertyValuesAs.samePropertyValuesAs(expectedBean);
    }

    public static Matcher<Node> hasXPath(String xPath, NamespaceContext namespaceContext, Matcher<? super String> valueMatcher) {
        return HasXPath.hasXPath(xPath, namespaceContext, valueMatcher);
    }

    public static Matcher<Node> hasXPath(String xPath, Matcher<? super String> valueMatcher) {
        return HasXPath.hasXPath(xPath, valueMatcher);
    }

    public static Matcher<Node> hasXPath(String xPath) {
        return HasXPath.hasXPath(xPath);
    }

    public static Matcher<Node> hasXPath(String xPath, NamespaceContext namespaceContext) {
        return HasXPath.hasXPath(xPath, namespaceContext);
    }
}

