/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hamcrest.generator.qdox.model.AbstractJavaEntity;
import org.hamcrest.generator.qdox.model.ClassLibrary;
import org.hamcrest.generator.qdox.model.DefaultDocletTagFactory;
import org.hamcrest.generator.qdox.model.DocletTag;
import org.hamcrest.generator.qdox.model.DocletTagFactory;
import org.hamcrest.generator.qdox.model.JavaClass;
import org.hamcrest.generator.qdox.model.JavaClassParent;
import org.hamcrest.generator.qdox.model.JavaField;
import org.hamcrest.generator.qdox.model.JavaMethod;
import org.hamcrest.generator.qdox.model.JavaParameter;
import org.hamcrest.generator.qdox.model.JavaSource;
import org.hamcrest.generator.qdox.model.Type;
import org.hamcrest.generator.qdox.parser.Builder;
import org.hamcrest.generator.qdox.parser.structs.ClassDef;
import org.hamcrest.generator.qdox.parser.structs.FieldDef;
import org.hamcrest.generator.qdox.parser.structs.MethodDef;
import org.hamcrest.generator.qdox.parser.structs.TagDef;

public class ModelBuilder
implements Builder {
    private final ClassLibrary classLibrary;
    private final JavaSource source;
    private JavaClassParent currentParent;
    private JavaClass currentClass;
    private String lastComment;
    private List lastTagSet;
    private DocletTagFactory docletTagFactory;

    public ModelBuilder() {
        this(new ClassLibrary(null), new DefaultDocletTagFactory());
    }

    public ModelBuilder(ClassLibrary classLibrary, DocletTagFactory docletTagFactory) {
        this.classLibrary = classLibrary;
        this.docletTagFactory = docletTagFactory;
        this.source = new JavaSource();
        this.source.setClassLibrary(classLibrary);
        this.currentParent = this.source;
    }

    public void addPackage(String packageName) {
        this.source.setPackage(packageName);
    }

    public void addImport(String importName) {
        this.source.addImport(importName);
    }

    public void addJavaDoc(String text) {
        this.lastComment = text;
        this.lastTagSet = new LinkedList();
    }

    public void addJavaDocTag(TagDef tagDef) {
        this.lastTagSet.add(tagDef);
    }

    public void beginClass(ClassDef def) {
        this.currentClass = new JavaClass();
        this.currentClass.setParent(this.currentParent);
        this.currentClass.setLineNumber(def.lineNumber);
        this.currentClass.setName(def.name);
        this.currentClass.setInterface("interface".equals(def.type));
        this.currentClass.setEnum("enum".equals(def.type));
        if (this.currentClass.isInterface()) {
            this.currentClass.setSuperClass(null);
        } else if (!this.currentClass.isEnum()) {
            this.currentClass.setSuperClass(def.extendz.size() > 0 ? this.createType((String)def.extendz.toArray()[0], 0) : null);
        }
        Set implementSet = this.currentClass.isInterface() ? def.extendz : def.implementz;
        Iterator implementIt = implementSet.iterator();
        Type[] implementz = new Type[implementSet.size()];
        for (int i = 0; i < implementz.length && implementIt.hasNext(); ++i) {
            implementz[i] = this.createType((String)implementIt.next(), 0);
        }
        this.currentClass.setImplementz(implementz);
        String[] modifiers = new String[def.modifiers.size()];
        def.modifiers.toArray(modifiers);
        this.currentClass.setModifiers(modifiers);
        this.addJavaDoc(this.currentClass);
        if ("@interface".equals(def.type)) {
            return;
        }
        this.currentParent.addClass(this.currentClass);
        this.currentParent = this.currentClass;
        this.classLibrary.add(this.currentClass.getFullyQualifiedName());
    }

    public void endClass() {
        this.currentParent = this.currentClass.getParent();
        this.currentClass = this.currentParent instanceof JavaClass ? (JavaClass)this.currentParent : null;
    }

    private Type createType(String typeName, int dimensions) {
        if (typeName == null || typeName.equals("")) {
            return null;
        }
        return Type.createUnresolved(typeName, dimensions, this.currentClass);
    }

    private void addJavaDoc(AbstractJavaEntity entity) {
        if (this.lastComment == null) {
            return;
        }
        entity.setComment(this.lastComment);
        Iterator tagDefIterator = this.lastTagSet.iterator();
        ArrayList<DocletTag> tagList = new ArrayList<DocletTag>();
        while (tagDefIterator.hasNext()) {
            TagDef tagDef = (TagDef)tagDefIterator.next();
            tagList.add(this.docletTagFactory.createDocletTag(tagDef.name, tagDef.text, entity, tagDef.lineNumber));
        }
        entity.setTags(tagList);
        this.lastComment = null;
    }

    public void addMethod(MethodDef def) {
        JavaMethod currentMethod = new JavaMethod();
        currentMethod.setParentClass(this.currentClass);
        currentMethod.setLineNumber(def.lineNumber);
        currentMethod.setName(def.name);
        currentMethod.setReturns(this.createType(def.returns, def.dimensions));
        currentMethod.setConstructor(def.constructor);
        JavaParameter[] params = new JavaParameter[def.params.size()];
        int i = 0;
        Iterator iterator = def.params.iterator();
        while (iterator.hasNext()) {
            FieldDef fieldDef = (FieldDef)iterator.next();
            params[i++] = new JavaParameter(this.createType(fieldDef.type, fieldDef.dimensions), fieldDef.name, fieldDef.isVarArgs);
        }
        currentMethod.setParameters(params);
        Type[] exceptions = new Type[def.exceptions.size()];
        int index = 0;
        Iterator iter = def.exceptions.iterator();
        while (iter.hasNext()) {
            exceptions[index++] = this.createType((String)iter.next(), 0);
        }
        currentMethod.setExceptions(exceptions);
        String[] modifiers = new String[def.modifiers.size()];
        def.modifiers.toArray(modifiers);
        currentMethod.setModifiers(modifiers);
        currentMethod.setSourceCode(def.body);
        this.addJavaDoc(currentMethod);
        this.currentClass.addMethod(currentMethod);
    }

    public void addField(FieldDef def) {
        JavaField currentField = new JavaField();
        currentField.setParent(this.currentClass);
        currentField.setLineNumber(def.lineNumber);
        currentField.setName(def.name);
        currentField.setType(this.createType(def.type, def.dimensions));
        String[] modifiers = new String[def.modifiers.size()];
        def.modifiers.toArray(modifiers);
        currentField.setModifiers(modifiers);
        currentField.setInitializationExpression(def.body);
        this.addJavaDoc(currentField);
        this.currentClass.addField(currentField);
    }

    public JavaSource getSource() {
        return this.source;
    }
}

