/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipHelper {
    public static void extractEntriesFromArchive(ZipFile archive, String entryNamePrefix, File destDir) throws IOException {
        assert (archive != null);
        assert (entryNamePrefix != null);
        assert (destDir != null && destDir.isDirectory());
        Enumeration<? extends ZipEntry> entries = archive.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith(entryNamePrefix)) continue;
            if (entry.isDirectory()) {
                File extractedFile = new File(destDir, entryName);
                extractedFile.mkdirs();
                continue;
            }
            InputStream inputStream = archive.getInputStream(entry);
            Throwable throwable = null;
            try {
                File extractedFile = new File(destDir, entryName);
                extractedFile.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(extractedFile);
                Throwable throwable2 = null;
                try {
                    byte[] buffer = new byte[2048];
                    int length = inputStream.read(buffer);
                    while (length > 0) {
                        fileOutputStream.write(buffer, 0, length);
                        length = inputStream.read(buffer);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (fileOutputStream == null) continue;
                    if (throwable2 != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    fileOutputStream.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
    }
}

