/**
 * Copyright (c) 2010-2012 EBM WebSourcing, 2012-2023 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the New BSD License (3-clause license).
 *
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the New BSD License (3-clause license)
 * for more details.
 *
 * You should have received a copy of the New BSD License (3-clause license)
 * along with this program/library; If not, see http://directory.fsf.org/wiki/License:BSD_3Clause/
 * for the New BSD License (3-clause license).
 */
package com.ebmwebsourcing.easycommons.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/**
 * @author Marc Jambert - EBM WebSourcing
 */
public class ZipHelper {

	/**
	 * Extract all the archive entries with a name starting with the specified
	 * name prefix to the specified destination directory
	 * 
	 * @param archive
	 *            the archive which contains the entries to extract
	 * @param entryNamePrefix
	 *            the name prefix of entries to extract from the archive
	 * @throws IOException
	 *             if an I/O entry has occurred
	 */
	public static void extractEntriesFromArchive(ZipFile archive, String entryNamePrefix, File destDir) throws IOException {
		assert archive != null;
		assert entryNamePrefix != null;
		assert destDir != null && destDir.isDirectory();
    	
    	Enumeration<? extends ZipEntry> entries = archive.entries();
    	while(entries.hasMoreElements()) {
    		ZipEntry entry = entries.nextElement();
        	String entryName = entry.getName();
    		if(entryName.startsWith(entryNamePrefix)) {
    			if(entry.isDirectory()) {
					File extractedFile = new File(destDir, entryName);
					extractedFile.mkdirs();
    			} else {
                    try (InputStream inputStream = archive.getInputStream(entry)) {
                        File extractedFile = new File(destDir, entryName);
                        extractedFile.getParentFile().mkdirs();
                        try (FileOutputStream fileOutputStream = new FileOutputStream(extractedFile)) {
                            byte[] buffer = new byte[2048];
                            int length = inputStream.read(buffer);
                            while (length > 0) {
                                fileOutputStream.write(buffer, 0, length);
                                length = inputStream.read(buffer);
                            }
                        }
	            	}
    			}
    		}
    	}
		
	}


}
