/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.lang.reflect;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static final Set<Class<?>> findAllImplementedInterfaces(Class<?> clazz) {
        HashSet implementedInterfaces = new HashSet();
        Class<?>[] directlyImplementedInterfaces = clazz.getInterfaces();
        implementedInterfaces.addAll(Arrays.asList(directlyImplementedInterfaces));
        for (Class<?> directlyImplementedInterface : directlyImplementedInterfaces) {
            implementedInterfaces.addAll(ReflectionHelper.findAllImplementedInterfaces(directlyImplementedInterface));
        }
        if (clazz.getSuperclass() != null) {
            implementedInterfaces.addAll(ReflectionHelper.findAllImplementedInterfaces(clazz.getSuperclass()));
        }
        return implementedInterfaces;
    }

    public static final Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        assert (clazz != null);
        assert (methodName != null);
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            throw new UncheckedException(String.format("Cannot get method '%s' on class '%s' (SecurityException).", methodName, clazz.getSimpleName()), e);
        }
        catch (NoSuchMethodException e) {
            throw new UncheckedException(String.format("Cannot get method '%s' on class '%s' (NoSuchMethodException).", methodName, clazz.getSimpleName()), e);
        }
    }

    public static final List<Method> getPublicDeclaredMethods(Class<?> clazz) {
        assert (clazz != null);
        try {
            ArrayList<Method> methods = new ArrayList<Method>();
            for (Method m : clazz.getDeclaredMethods()) {
                if (m.getModifiers() != 1) continue;
                methods.add(m);
            }
            return methods;
        }
        catch (SecurityException e) {
            throw new UncheckedException(String.format("Cannot get methods on class '%s' (SecurityException).", clazz.getSimpleName()), e);
        }
    }

    public static final Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        assert (clazz != null);
        assert (methodName != null);
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            throw new UncheckedException(String.format("Cannot get method '%s' on class '%s' (SecurityException).", methodName, clazz.getSimpleName()), e);
        }
        catch (NoSuchMethodException e) {
            throw new UncheckedException(String.format("Cannot get method '%s' on class '%s' (NoSuchMethodException).", methodName, clazz.getSimpleName()), e);
        }
    }

    public static final Object invokeMethod(Object obj, Method method, Object ... args) throws InvocationTargetException {
        assert (obj != null);
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalArgumentException e) {
            throw new UncheckedException(String.format("Cannot invoke reflectively '%s' method on class '%s' (IllegalArgumentException).", method.getName(), obj.getClass().getSimpleName()), e);
        }
        catch (IllegalAccessException e) {
            throw new UncheckedException(String.format("Cannot invoke reflectively '%s' method on class '%s' (IllegalAccessException).", method.getName(), obj.getClass().getSimpleName()), e);
        }
    }

    @Deprecated
    public static final Object invokePrivateMethod(Object obj, String methodName, Object ... args) throws InvocationTargetException {
        assert (obj != null);
        try {
            ArrayList parameterTypes = new ArrayList();
            for (Object param : args) {
                parameterTypes.add(param.getClass());
            }
            Method method = ReflectionHelper.getDeclaredMethod(obj.getClass(), methodName, parameterTypes.toArray(new Class[parameterTypes.size()]));
            method.setAccessible(true);
            return method.invoke(obj, args);
        }
        catch (IllegalArgumentException e) {
            throw new UncheckedException(String.format("Cannot invoke reflectively '%s' method on class '%s' (IllegalArgumentException).", methodName, obj.getClass().getSimpleName()), e);
        }
        catch (IllegalAccessException e) {
            throw new UncheckedException(String.format("Cannot invoke reflectively '%s' method on class '%s' (IllegalAccessException).", methodName, obj.getClass().getSimpleName()), e);
        }
    }

    public static final Object invokePrivateMethod(Object obj, String methodName, Object[] args, Class<?>[] types) throws InvocationTargetException {
        assert (obj != null);
        return ReflectionHelper.invokePrivateMethod(null, obj, methodName, args, types);
    }

    public static final Object invokePrivateMethod(Class<?> clazz, Object obj, String methodName, Object[] args, Class<?>[] types) throws InvocationTargetException {
        Class<?> actualClass;
        if (clazz != null) {
            actualClass = clazz;
        } else if (obj != null) {
            actualClass = obj.getClass();
        } else {
            throw new UncheckedException("A class or an object is required");
        }
        try {
            Method method = ReflectionHelper.getDeclaredMethod(actualClass, methodName, types);
            method.setAccessible(true);
            if (obj != null) {
                return method.invoke(obj, args);
            }
            return method.invoke(null, args);
        }
        catch (IllegalArgumentException e) {
            throw new UncheckedException(String.format("Cannot invoke reflectively '%s' method on class '%s' (IllegalArgumentException).", methodName, actualClass.getSimpleName()), e);
        }
        catch (IllegalAccessException e) {
            throw new UncheckedException(String.format("Cannot invoke reflectively '%s' method on class '%s' (IllegalAccessException).", methodName, actualClass.getClass().getSimpleName()), e);
        }
    }

    public static final <T> T newInstance(Class<T> clazz, Object ... args) throws InvocationTargetException {
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(args);
        }
        catch (SecurityException e) {
            throw new UncheckedException(String.format("Cannot get default constructor of class '%s' (SecurityException).", clazz.getSimpleName()), e);
        }
        catch (NoSuchMethodException e) {
            throw new UncheckedException(String.format("Cannot get default constructor of class '%s' (NoSuchMethodException).", clazz.getSimpleName()), e);
        }
        catch (IllegalArgumentException e) {
            throw new UncheckedException(String.format("Cannot create new instance of class '%s' (IllegalArgumentException).", clazz.getSimpleName()), e);
        }
        catch (InstantiationException e) {
            throw new UncheckedException(String.format("Cannot create new instance of class '%s' (InstantiationException).", clazz.getSimpleName()), e);
        }
        catch (IllegalAccessException e) {
            throw new UncheckedException(String.format("Cannot create new instance of class '%s' (IllegalAccessException).", clazz.getSimpleName()), e);
        }
    }

    public static final <T> T newInstance(String className, ClassLoader cl, Object ... args) throws InvocationTargetException {
        Class<T> clazz = ReflectionHelper.loadClass(className, cl);
        return ReflectionHelper.newInstance(clazz, args);
    }

    public static final <T> Class<T> loadClass(String className, ClassLoader cl) {
        assert (className != null);
        try {
            if (cl == null) {
                cl = ReflectionHelper.class.getClassLoader();
                if (cl == null) {
                    throw new UncheckedException("Cannot load classloader");
                }
                return cl.loadClass(className);
            }
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new UncheckedException(String.format("Cannot load class '%s'", className), e);
        }
    }

    public static final Collection<Method> findMethodsThatReturnType(Class<?> clazz, Class<?> returnType) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m : clazz.getMethods()) {
            if (!m.getReturnType().equals(returnType)) continue;
            methods.add(m);
        }
        return methods;
    }

    public static final Object getFieldValue(Class<?> clazz, Object instance, String fieldName, boolean removeFinalModifier) throws IllegalArgumentException {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            if (removeFinalModifier) {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            return field.get(instance);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SecurityException e) {
            throw new UncheckedException(String.format("Cannot get reflectively value of field '%s' on class '%s' (SecurityException).", fieldName, clazz.getSimpleName()), e);
        }
        catch (IllegalArgumentException e) {
            throw new UncheckedException(String.format("Cannot get reflectively value of field '%s' on class '%s' (IllegalArgumentException).", fieldName, clazz.getSimpleName()), e);
        }
        catch (IllegalAccessException e) {
            throw new UncheckedException(String.format("Cannot get reflectively value of field '%s' on class '%s' (IllegalAccessException).", fieldName, clazz.getSimpleName()), e);
        }
    }

    @Deprecated
    public static final Object getPrivateFieldValue(Class<?> clazz, Object instance, String fieldName) {
        try {
            return ReflectionHelper.getFieldValue(clazz, instance, fieldName, false);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static final Object getFieldValue(Object obj, Field field) {
        assert (obj != null);
        assert (field != null);
        try {
            return field.get(obj);
        }
        catch (IllegalArgumentException e) {
            throw new UncheckedException(String.format("Cannot get reflectively value of field '%s' on class '%s' (IllegalArgumentException).", field.getName(), obj.getClass().getSimpleName()), e);
        }
        catch (IllegalAccessException e) {
            throw new UncheckedException(String.format("Cannot get reflectively value of field '%s' on class '%s' (IllegalAccessException).", field.getName(), obj.getClass().getSimpleName()), e);
        }
    }

    @Deprecated
    public static void setPrivateField(Object obj, String fieldName, Object value) throws IllegalArgumentException {
        ReflectionHelper.setFieldValue(obj.getClass(), obj, fieldName, value, false);
    }

    public static void setFieldValue(Object obj, String fieldName, Object value, boolean removeFinalModifier) throws IllegalArgumentException {
        ReflectionHelper.setFieldValue(obj.getClass(), obj, fieldName, value, removeFinalModifier);
    }

    public static void setFieldValue(Class<?> clazz, String fieldName, Object value, boolean removeFinalModifier) throws IllegalArgumentException {
        ReflectionHelper.setFieldValue(clazz, null, fieldName, value, removeFinalModifier);
    }

    public static void setFieldValue(Class<?> clazz, Object obj, String fieldName, Object value, boolean removeFinalModifier) throws IllegalArgumentException {
        assert (clazz != null);
        assert (fieldName != null);
        assert (value != null);
        boolean set = false;
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length && !set; ++i) {
            if (!fieldName.equals(fields[i].getName())) continue;
            set = true;
            try {
                fields[i].setAccessible(true);
                if (removeFinalModifier) {
                    Field modifiersField = Field.class.getDeclaredField("modifiers");
                    modifiersField.setAccessible(true);
                    modifiersField.setInt(fields[i], fields[i].getModifiers() & 0xFFFFFFEF);
                }
                fields[i].set(obj, value);
                continue;
            }
            catch (IllegalAccessException ex) {
                throw new UncheckedException(String.format("Cannot set reflectively value of field '%s' on class '%s' (IllegalAccessException).", fieldName, clazz.getSimpleName()), ex);
            }
            catch (NoSuchFieldException ex) {
                throw new UncheckedException(String.format("Cannot set reflectively value of field '%s' on class '%s' (NoSuchFieldException).", fieldName, clazz.getSimpleName()), ex);
            }
            catch (SecurityException ex) {
                throw new UncheckedException(String.format("Cannot set reflectively value of field '%s' on class '%s' (SecurityException).", fieldName, clazz.getSimpleName()), ex);
            }
        }
        if (!set) {
            throw new IllegalArgumentException("Field doesn't exist: " + fieldName);
        }
    }

    public static final void setFieldValue(Object obj, Field field, Object newValue) {
        assert (obj != null);
        assert (field != null);
        try {
            field.set(obj, newValue);
        }
        catch (IllegalArgumentException e) {
            throw new UncheckedException(String.format("Cannot set reflectively value of field '%s' on class '%s' (IllegalArgumentException).", field.getName(), obj.getClass().getSimpleName()), e);
        }
        catch (IllegalAccessException e) {
            throw new UncheckedException(String.format("Cannot set reflectively value of field '%s' on class '%s' (IllegalAccessException).", field.getName(), obj.getClass().getSimpleName()), e);
        }
    }

    public static final boolean isOrInheritedFrom(Class<?> clazz, String canonicalName) {
        Class<?> superclass;
        assert (clazz != null);
        assert (canonicalName != null);
        String clazzCanonicalName = clazz.getCanonicalName();
        boolean isOrInheritedFrom = canonicalName.equals(clazzCanonicalName) ? true : ((superclass = clazz.getSuperclass()) != null ? ReflectionHelper.isOrInheritedFrom(superclass, canonicalName) : false);
        return isOrInheritedFrom;
    }
}

