/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.stream;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.lang.reflect.ReflectionHelper;
import com.ebmwebsourcing.easycommons.stream.EasyByteArrayOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Arrays;

public class StreamHelper {
    private static final int EOF = -1;
    public static final int DEFAULT_BUFFER_SIZE = 2048;

    public static void copy(InputStream fromStream, OutputStream toStream) {
        StreamHelper.copy(fromStream, toStream, 2048);
    }

    public static void copy(InputStream fromStream, OutputStream toStream, int bufferSize) {
        assert (fromStream != null);
        assert (toStream != null);
        assert (bufferSize > 0);
        int n = 0;
        byte[] buf = new byte[bufferSize];
        try {
            while (-1 != (n = fromStream.read(buf))) {
                toStream.write(buf, 0, n);
            }
            toStream.flush();
        }
        catch (IOException e) {
            throw new UncheckedException("Cannot read or write bytes on given streams", (Throwable)e);
        }
    }

    public static byte[] getBytes(InputStream input) {
        int length = input instanceof ByteArrayInputStream ? ((ByteArrayInputStream)input).available() : 32;
        try (EasyByteArrayOutputStream result = new EasyByteArrayOutputStream(length);){
            StreamHelper.copy(input, result);
            byte[] byArray = result.toRawByteArray();
            return byArray;
        }
    }

    public static byte[] getAllBytes(ByteArrayInputStream input) {
        try {
            byte[] buf = (byte[])ReflectionHelper.getFieldValue(ByteArrayInputStream.class, (Object)input, (String)"buf", (boolean)false);
            int count = (Integer)ReflectionHelper.getFieldValue(ByteArrayInputStream.class, (Object)input, (String)"count", (boolean)false);
            return Arrays.copyOf(buf, count);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected implementation of ByteArrayInputStream!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(InputStream is) throws IOException {
        StringWriter w = null;
        try {
            int n;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            w = new StringWriter();
            char[] buffer = new char[1024];
            while ((n = reader.read(buffer)) != -1) {
                w.write(buffer, 0, n);
            }
        }
        finally {
            is.close();
        }
        return w.toString();
    }
}

