/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.log;

import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingUtil {
    protected final Logger log;
    protected final String name;

    public LoggingUtil(Logger logger) {
        this(logger, "");
    }

    public LoggingUtil(Logger logger, String loggerName) {
        this.log = logger;
        this.name = loggerName != null && loggerName.trim().length() > 0 ? "[" + loggerName + "] " : "";
    }

    public void call() {
        if (this.isTraceEnabled()) {
            this.log.log(Level.FINEST, this.name + "-CALL-" + LoggingUtil.classAndMethod());
        }
    }

    public void call(Object msg) {
        if (this.isTraceEnabled()) {
            this.log.log(Level.FINEST, this.name + "-CALL-" + LoggingUtil.classAndMethod() + " " + msg);
        }
    }

    public void start() {
        if (this.isTraceEnabled()) {
            this.log.log(Level.FINEST, this.name + "-START-" + LoggingUtil.classAndMethod());
        }
    }

    public void start(Object msg) {
        if (this.isTraceEnabled()) {
            this.log.log(Level.FINEST, this.name + "-START-" + LoggingUtil.classAndMethod() + " " + msg);
        }
    }

    public void end() {
        if (this.isTraceEnabled()) {
            this.log.log(Level.FINEST, this.name + "-END-" + LoggingUtil.classAndMethod());
        }
    }

    public void end(Object msg) {
        if (this.isTraceEnabled()) {
            this.log.log(Level.FINEST, this.name + "-END-" + LoggingUtil.classAndMethod() + " " + msg);
        }
    }

    public void trace(Object message) {
        this.log(Level.FINEST, message, null);
    }

    public void debug(Object message) {
        this.log(Level.FINE, message, null);
    }

    public void debug(Object message, Throwable throwable) {
        this.log(Level.FINE, message, throwable);
    }

    public void config(Object message) {
        this.log(Level.CONFIG, message, null);
    }

    public void info(Object message) {
        this.log(Level.INFO, message, null);
    }

    public void info(Object message, Throwable throwable) {
        this.log(Level.INFO, message, throwable);
    }

    public void warning(Object message) {
        this.log(Level.WARNING, message, null);
    }

    public void warning(Object message, Throwable throwable) {
        this.log(Level.WARNING, message, throwable);
    }

    public void error(Object message) {
        this.log(Level.SEVERE, message, null);
    }

    public void error(Object message, Throwable throwable) {
        this.log(Level.SEVERE, message, throwable);
    }

    private void log(Level level, Object message, Throwable throwable) {
        if (this.isLevelEnabled(level)) {
            String msg = this.log.isLoggable(Level.FINER) ? this.name + LoggingUtil.classAndMethod() + " " + message : this.name + message;
            if (throwable != null) {
                this.log.log(level, msg, throwable);
            } else {
                this.log.log(level, msg);
            }
        }
    }

    public void assertOrLog(boolean assertion, Object message) {
        assert (assertion) : message.toString();
        if (!assertion) {
            this.error("Assertion failed", (Throwable)((Object)new AssertionError((Object)message.toString())));
        }
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(Level.FINEST);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(Level.FINE);
    }

    public boolean isConfigEnabled() {
        return this.isLevelEnabled(Level.CONFIG);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(Level.WARNING);
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(Level.SEVERE);
    }

    private boolean isLevelEnabled(Level level) {
        return this.log != null && this.log.isLoggable(level);
    }

    private static String classAndMethod() {
        String result = null;
        Throwable t = new Throwable();
        StackTraceElement[] ste = t.getStackTrace();
        if (ste != null && ste.length > 2) {
            String className;
            int index;
            StackTraceElement element = ste[2];
            if (element.getClassName().endsWith(LoggingUtil.class.getName())) {
                element = ste[3];
            }
            if ((index = (className = element.getClassName()).lastIndexOf(".")) > -1) {
                className = className.substring(index + 1, className.length());
            }
            result = className + "." + element.getMethodName() + "()";
        }
        return result;
    }

    public String getName() {
        return this.log.getName();
    }

    public Logger getLogger() {
        return this.log;
    }
}

