/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.pooling;

import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.pooling.PoolPolicy;
import com.ebmwebsourcing.easycommons.pooling.ResourceHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;

public class GenericResourcePool<T> {
    private List<T> usedResources;
    private List<T> availableResources;
    private Semaphore semaphore;
    private ResourceHandler<T> resourceHandler;
    private PoolPolicy poolPolicy;

    public GenericResourcePool(ResourceHandler<T> ressourceHandler, int minSize, int maxSize, PoolPolicy poolPolicy) {
        assert (ressourceHandler != null);
        assert (minSize >= 0);
        assert (maxSize >= minSize);
        assert (poolPolicy != null);
        this.resourceHandler = ressourceHandler;
        this.poolPolicy = poolPolicy;
        this.semaphore = new Semaphore(maxSize);
        this.availableResources = new ArrayList<T>();
        this.usedResources = new ArrayList<T>();
        for (int i = 0; i < minSize; ++i) {
            this.availableResources.add(this.resourceHandler.create());
        }
    }

    public final T take() {
        if (this.poolPolicy == PoolPolicy.WAIT) {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new PoolException(e);
            }
        } else {
            boolean available = this.semaphore.tryAcquire();
            if (!available) {
                throw new PoolException("There is no more available resource in the pool.");
            }
        }
        T resource = this.getAvailableResource();
        return resource;
    }

    private synchronized T getAvailableResource() {
        T resource = this.availableResources.isEmpty() ? this.resourceHandler.create() : this.availableResources.remove(0);
        this.usedResources.add(resource);
        this.resourceHandler.onTake(resource);
        return resource;
    }

    public final void release(T resource) {
        this.putBackResource(resource);
        this.semaphore.release();
    }

    private synchronized void putBackResource(T resource) {
        assert (this.usedResources.remove(resource));
        this.availableResources.add(resource);
        this.resourceHandler.onRelease(resource);
    }
}

