/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.registry;

import com.ebmwebsourcing.easycommons.registry.KeyAlreadyBoundException;
import com.ebmwebsourcing.easycommons.registry.KeyNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class ResourceRegistry<T> {
    private Map<String, T> registry = new HashMap<String, T>();

    public synchronized void register(String key, T resource) {
        assert (key != null);
        assert (resource != null);
        T previouslyMappedRessource = this.registry.get(key);
        if (previouslyMappedRessource != null) {
            throw new KeyAlreadyBoundException("The provided key is already bound: " + key);
        }
        this.registry.put(key, resource);
    }

    public synchronized void unregister(String key) {
        assert (key != null);
        T previouslyMappedRessource = this.registry.get(key);
        if (previouslyMappedRessource == null) {
            throw new KeyNotFoundException("The given key isn't found in registry: " + key);
        }
        this.registry.remove(key);
    }

    public T lookup(String key) {
        assert (key != null);
        return this.registry.get(key);
    }
}

