/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml;

import com.ebmwebsourcing.easycommons.pooling.GenericResourcePool;
import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.pooling.PoolPolicy;
import com.ebmwebsourcing.easycommons.pooling.ResourceHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public class JVMDocumentBuilderResourcePool {
    private final GenericResourcePool<DocumentBuilder> jvmDocumentBuilderResourcePool;

    public JVMDocumentBuilderResourcePool(int minPoolSize, int maxPoolSize, PoolPolicy poolPolicy) {
        JVMDocumentBuilderResourceHandler jvmDocumentBuilderResourceHandler = new JVMDocumentBuilderResourceHandler();
        this.jvmDocumentBuilderResourcePool = new GenericResourcePool<DocumentBuilder>(jvmDocumentBuilderResourceHandler, minPoolSize, maxPoolSize, poolPolicy);
    }

    public DocumentBuilder take() {
        return this.jvmDocumentBuilderResourcePool.take();
    }

    public final void release(DocumentBuilder jvmDocumentBuilder) {
        this.jvmDocumentBuilderResourcePool.release(jvmDocumentBuilder);
    }

    private static class JVMDocumentBuilderResourceHandler
    implements ResourceHandler<DocumentBuilder> {
        final DocumentBuilderFactory jvmDocumentBuilderFactory;

        public JVMDocumentBuilderResourceHandler() {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
                Thread.currentThread().setContextClassLoader(systemClassLoader);
                this.jvmDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
            this.jvmDocumentBuilderFactory.setNamespaceAware(true);
        }

        @Override
        public DocumentBuilder create() {
            try {
                return this.jvmDocumentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new PoolException(e);
            }
        }

        @Override
        public void onRelease(DocumentBuilder jvmDocumentBuilder) {
        }

        @Override
        public void onTake(DocumentBuilder jvmDocumentBuilder) {
        }
    }
}

