/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml;

import com.ebmwebsourcing.easycommons.stream.EasyByteArrayOutputStream;
import com.ebmwebsourcing.easycommons.stream.InputStreamForker;
import com.ebmwebsourcing.easycommons.stream.ReaderInputStream;
import com.ebmwebsourcing.easycommons.stream.StreamHelper;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.Transformers;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SourceHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toFile(Source source, File fileToWrite) throws TransformerException, IOException {
        FileWriter writer = new FileWriter(fileToWrite);
        StreamResult result = new StreamResult(writer);
        Transformer transformer = Transformers.takeTransformer();
        try {
            transformer.transform(source, result);
        }
        finally {
            Transformers.releaseTransformer(transformer);
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Source source) throws TransformerException {
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        Transformer transformer = Transformers.takeTransformer();
        try {
            transformer.transform(source, result);
        }
        finally {
            Transformers.releaseTransformer(transformer);
        }
        return writer.toString();
    }

    private static SAXSource forkSAXSource(SAXSource source) throws IOException {
        InputSource result;
        InputSource inputSource = source.getInputSource();
        if (inputSource.getCharacterStream() != null) {
            InputStreamForker streamForker = new InputStreamForker((InputStream)new ReaderInputStream(inputSource.getCharacterStream()));
            inputSource.setCharacterStream(new InputStreamReader(streamForker.fork()));
            result = new InputSource(streamForker.fork());
        } else if (inputSource.getByteStream() != null) {
            InputStreamForker streamForker = new InputStreamForker(inputSource.getByteStream());
            inputSource.setByteStream(streamForker.fork());
            result = new InputSource(streamForker.fork());
        } else {
            result = new InputSource(inputSource.getSystemId());
        }
        result.setPublicId(inputSource.getPublicId());
        result.setEncoding(inputSource.getEncoding());
        return new SAXSource(source.getXMLReader(), result);
    }

    private static StreamSource forkStreamSource(StreamSource source) throws IOException {
        StreamSource result;
        if (source.getInputStream() != null) {
            InputStreamForker streamForker = new InputStreamForker(source.getInputStream());
            source.setInputStream(streamForker.fork());
            result = new StreamSource(streamForker.fork());
        } else if (source.getReader() != null) {
            InputStreamForker streamForker = new InputStreamForker((InputStream)new ReaderInputStream(source.getReader()));
            source.setReader(new InputStreamReader(streamForker.fork()));
            result = new StreamSource(streamForker.fork());
        } else {
            result = new StreamSource(source.getSystemId());
        }
        result.setPublicId(source.getPublicId());
        return result;
    }

    public static Source fork(Source source) throws IOException {
        if (source instanceof DOMSource) {
            return source;
        }
        if (source instanceof StreamSource) {
            return SourceHelper.forkStreamSource((StreamSource)source);
        }
        if (source instanceof SAXSource) {
            return SourceHelper.forkSAXSource((SAXSource)source);
        }
        throw new IllegalArgumentException("Only DOMSource, StreamSource and SAXSource are supported right now, got a " + source.getClass().getName());
    }

    public static InputStream getUnderlyingInputStream(Source source) {
        if (source instanceof StreamSource) {
            return ((StreamSource)source).getInputStream();
        }
        if (source instanceof SAXSource) {
            return ((SAXSource)source).getInputSource().getByteStream();
        }
        return null;
    }

    public static EasyByteArrayOutputStream toEasyByteArrayOutputStream(Source source) throws TransformerException {
        EasyByteArrayOutputStream os = new EasyByteArrayOutputStream();
        Transformer transformer = Transformers.takeTransformer();
        try {
            transformer.transform(source, new StreamResult((OutputStream)os));
        }
        finally {
            Transformers.releaseTransformer(transformer);
        }
        return os;
    }

    public static byte[] toByteArray(Source source) throws TransformerException {
        InputStream is = SourceHelper.getUnderlyingInputStream(source);
        if (is instanceof ByteArrayInputStream) {
            try {
                return StreamHelper.getAllBytes((ByteArrayInputStream)((ByteArrayInputStream)is));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return SourceHelper.toEasyByteArrayOutputStream(source).toRawByteArray();
    }

    public static InputStream toInputStream(Source source) throws TransformerException {
        InputStream is = SourceHelper.getUnderlyingInputStream(source);
        if (is != null) {
            return is;
        }
        return SourceHelper.toEasyByteArrayOutputStream(source).toByteArrayInputStream();
    }

    public static InputSource toInputSource(Source source) throws TransformerException {
        if (source instanceof SAXSource) {
            return ((SAXSource)source).getInputSource();
        }
        if (source instanceof StreamSource) {
            InputSource inputSource = new InputSource();
            inputSource.setPublicId(((StreamSource)source).getPublicId());
            inputSource.setSystemId(source.getSystemId());
            inputSource.setCharacterStream(((StreamSource)source).getReader());
            inputSource.setByteStream(((StreamSource)source).getInputStream());
            return inputSource;
        }
        InputSource inputSource = new InputSource(SourceHelper.toInputStream(source));
        inputSource.setSystemId(source.getSystemId());
        return inputSource;
    }

    public static InputSource toInputSource(Document document) throws TransformerException {
        return SourceHelper.toInputSource(SourceHelper.toDOMSource(document));
    }

    public static DOMSource toDOMSource(Document document) {
        document.normalizeDocument();
        return new DOMSource(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document toDocument(Source source) throws TransformerException {
        Document document = DocumentBuilders.newDocument();
        DOMResult domResult = new DOMResult(document);
        Transformer transformer = Transformers.takeTransformer();
        try {
            transformer.transform(source, domResult);
        }
        finally {
            Transformers.releaseTransformer(transformer);
        }
        return document;
    }

    public static DOMSource toDOMSource(InputSource inputSource) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder db = factory.newDocumentBuilder();
            Document document = db.parse(inputSource);
            DOMSource res = new DOMSource(document);
            res.setSystemId(inputSource.getSystemId());
            return res;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }

    public static InputSource sourceToInputSource(Source source, String publicId, String systemId) {
        InputSource is = null;
        if (source instanceof SAXSource) {
            is = ((SAXSource)source).getInputSource();
        } else if (source instanceof DOMSource) {
            EasyByteArrayOutputStream baos = new EasyByteArrayOutputStream();
            Node node = ((DOMSource)source).getNode();
            if (node instanceof Document) {
                node = ((Document)node).getDocumentElement();
            }
            Element domElement = (Element)node;
            SourceHelper.ElementToStream(domElement, (OutputStream)baos);
            InputSource isource = new InputSource(source.getSystemId());
            isource.setByteStream(baos.toByteArrayInputStream());
            is = isource;
        } else if (source instanceof StreamSource) {
            StreamSource ss = (StreamSource)source;
            InputSource isource = new InputSource(ss.getSystemId());
            isource.setByteStream(ss.getInputStream());
            isource.setCharacterStream(ss.getReader());
            isource.setPublicId(ss.getPublicId());
            is = isource;
        } else {
            is = new InputSource(source.getSystemId());
        }
        if (is != null) {
            is.setPublicId(publicId);
            is.setSystemId(systemId);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ElementToStream(Element element, OutputStream out) {
        DOMSource source = new DOMSource(element);
        StreamResult result = new StreamResult(out);
        Transformer transformer = Transformers.takeTransformer();
        try {
            transformer.transform(source, result);
        }
        catch (Exception exception) {
        }
        finally {
            Transformers.releaseTransformer(transformer);
        }
    }
}

