/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml;

import com.ebmwebsourcing.easycommons.pooling.GenericResourcePool;
import com.ebmwebsourcing.easycommons.pooling.PoolPolicy;
import com.ebmwebsourcing.easycommons.pooling.ResourceHandler;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLPrettyPrinter {
    private static GenericResourcePool<TransformerFactory> transformerFactoryResourcePool = new GenericResourcePool<TransformerFactory>(new TransformerFactoryResourceHandler(), 1, Integer.MAX_VALUE, PoolPolicy.WAIT);

    public static String prettyPrint(Node xmlDocument, String encoding) {
        String result = "";
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            XMLPrettyPrinter.prettify(xmlDocument, (OutputStream)outStream, encoding);
            result = outStream.toString(encoding);
        }
        catch (Exception e) {
            System.err.println("write_dom failed:" + e);
        }
        return result;
    }

    public static String prettyPrint(Source source) throws TransformerException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        XMLPrettyPrinter.prettify(source, (OutputStream)outStream);
        return outStream.toString();
    }

    public static String prettyPrint(Document xmlDocument) {
        return XMLPrettyPrinter.prettyPrint(xmlDocument, XMLPrettyPrinter.getEncoding(xmlDocument));
    }

    public static String prettyPrint(Element node) {
        String res = null;
        if (node != null) {
            res = node instanceof Document ? XMLPrettyPrinter.prettyPrint(node, XMLPrettyPrinter.getEncoding((Document)((Object)node))) : XMLPrettyPrinter.prettyPrint(node, XMLPrettyPrinter.getEncoding(node.getOwnerDocument()));
        }
        return res;
    }

    public static String prettyPrint(Node node) {
        String res = null;
        if (node != null) {
            res = node instanceof Document ? XMLPrettyPrinter.prettyPrint(node, XMLPrettyPrinter.getEncoding((Document)node)) : XMLPrettyPrinter.prettyPrint(node, XMLPrettyPrinter.getEncoding(node.getOwnerDocument()));
        }
        return res;
    }

    public static void prettify(Node node, OutputStream out, String encoding) throws Exception {
        XMLPrettyPrinter.prettify(new DOMSource(node), out, encoding);
    }

    public static void prettify(Node node, OutputStream out) throws Exception {
        XMLPrettyPrinter.prettify(node, out, null);
    }

    public static void prettify(InputStream in, OutputStream out) throws Exception {
        XMLPrettyPrinter.prettify(new StreamSource(in), out);
    }

    public static void prettify(Source source, OutputStream out) throws TransformerException {
        XMLPrettyPrinter.prettify(source, out, null);
    }

    public static void prettify(Source source, OutputStream out, String encoding) throws TransformerException {
        Source stylesheetSource = XMLPrettyPrinter.getStyleSheetSource();
        Transformer transformer = XMLPrettyPrinter.getTransformer(stylesheetSource);
        if (encoding != null) {
            transformer.setOutputProperty("encoding", encoding);
        }
        transformer.transform(source, new StreamResult(out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Transformer getTransformer(Source stylesheetSource) throws TransformerConfigurationException {
        TransformerFactory transformerFactory = transformerFactoryResourcePool.take();
        try {
            Transformer transformer;
            Templates templates = transformerFactory.newTemplates(stylesheetSource);
            Transformer transformer2 = transformer = templates.newTransformer();
            return transformer2;
        }
        finally {
            transformerFactoryResourcePool.release(transformerFactory);
        }
    }

    public static String getEncoding(Document xmlDocument) {
        String encoding = xmlDocument.getInputEncoding();
        if (encoding == null) {
            encoding = xmlDocument.getXmlEncoding();
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    private static Source getStyleSheetSource() {
        StreamSource stylesheetSource = new StreamSource(XMLPrettyPrinter.class.getResourceAsStream("/prettyPrint.xsl"));
        return stylesheetSource;
    }

    private static class TransformerFactoryResourceHandler
    implements ResourceHandler<TransformerFactory> {
        private TransformerFactoryResourceHandler() {
        }

        @Override
        public TransformerFactory create() {
            return TransformerFactory.newInstance();
        }

        @Override
        public void onTake(TransformerFactory resource) {
        }

        @Override
        public void onRelease(TransformerFactory resource) {
        }
    }
}

