/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.schema.api.abstractElmt;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.SchemaReader;
import org.ow2.easywsdl.schema.api.absItf.AbsItfAttribute;
import org.ow2.easywsdl.schema.api.absItf.AbsItfComplexType;
import org.ow2.easywsdl.schema.api.absItf.AbsItfElement;
import org.ow2.easywsdl.schema.api.absItf.AbsItfImport;
import org.ow2.easywsdl.schema.api.absItf.AbsItfInclude;
import org.ow2.easywsdl.schema.api.absItf.AbsItfRedefine;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.api.absItf.AbsItfType;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;
import org.ow2.easywsdl.schema.api.extensions.SchemaLocatorImpl;

public abstract class AbstractSchemaImpl<E, T extends AbsItfType, El extends AbsItfElement, A extends AbsItfAttribute, Incl extends AbsItfInclude, Impt extends AbsItfImport, Red extends AbsItfRedefine>
extends AbstractSchemaElementImpl<E>
implements AbsItfSchema<T, El, A, Incl, Impt, Red> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(AbstractSchemaImpl.class.getName());
    private Map<SchemaReader.FeatureConstants, Object> features = new HashMap<SchemaReader.FeatureConstants, Object>();
    private NamespaceMapperImpl namespaceMapper = new NamespaceMapperImpl();
    private List<Impt> imports = new ArrayList<Impt>();
    private List<Incl> includes = new ArrayList<Incl>();
    private List<Red> redefines = new ArrayList<Red>();
    private List<T> types = new ArrayList<T>();
    private List<El> elements = new ArrayList<El>();
    private List<A> attributes = new ArrayList<A>();
    private String documentBaseURIString;
    private URI documentURI = null;

    public AbstractSchemaImpl() {
    }

    public abstract void initialize();

    public AbstractSchemaImpl(URI documentURI, E schema, NamespaceMapperImpl namespaceMapper, SchemaLocatorImpl schemaLocator) {
        super(schema, null);
        this.namespaceMapper = namespaceMapper;
        this.documentURI = documentURI;
    }

    public AbstractSchemaImpl(String baseURIString) {
        this.documentBaseURIString = baseURIString;
    }

    public void addImportElementsInAllList() {
        for (AbsItfImport impt : this.imports) {
            if (impt.getSchema() == null) continue;
            this.types.addAll(impt.getSchema().getTypes());
            this.elements.addAll(impt.getSchema().getElements());
            this.attributes.addAll(impt.getSchema().getAttributes());
        }
    }

    public void addIncludeElementsInAllList() {
        for (AbsItfInclude incl : this.includes) {
            if (incl.getSchema() == null) continue;
            this.types.addAll(incl.getSchema().getTypes());
            this.elements.addAll(incl.getSchema().getElements());
            this.attributes.addAll(incl.getSchema().getAttributes());
        }
    }

    public void addIncludeElementsInAllList(AbsItfInclude incl) {
        if (incl.getSchema() != null) {
            this.types.addAll(incl.getSchema().getTypes());
            this.elements.addAll(incl.getSchema().getElements());
            this.attributes.addAll(incl.getSchema().getAttributes());
        }
    }

    public void addRedefineElementsInAllList() {
        for (AbsItfRedefine red : this.redefines) {
            if (red.getSchema() == null) continue;
            this.types.addAll(red.getSchema().getTypes());
            this.elements.addAll(red.getSchema().getElements());
            this.attributes.addAll(red.getSchema().getAttributes());
        }
    }

    @Override
    public void addImport(Impt impt) {
        if (this.imports == null) {
            this.imports = new ArrayList<Impt>();
        }
        this.imports.add(impt);
    }

    @Override
    public List<Impt> getImports() {
        if (this.imports == null) {
            this.imports = new ArrayList<Impt>();
        }
        return this.imports;
    }

    @Override
    public List<Impt> getImports(String namespaceUri) {
        ArrayList<AbsItfImport> res = new ArrayList<AbsItfImport>();
        for (AbsItfImport impt : this.imports) {
            if (!impt.getNamespaceURI().equals(namespaceUri)) continue;
            res.add(impt);
        }
        return res;
    }

    @Override
    public void addInclude(Incl incl) throws SchemaException {
        if (this.includes == null) {
            this.includes = new ArrayList<Incl>();
        }
        this.includes.add(incl);
    }

    @Override
    public List<Incl> getIncludes() {
        if (this.includes == null) {
            this.includes = new ArrayList<Incl>();
        }
        return this.includes;
    }

    @Override
    public List<Incl> getIncludes(URI locationUri) {
        ArrayList<AbsItfInclude> res = new ArrayList<AbsItfInclude>();
        for (AbsItfInclude incl : this.includes) {
            if (!incl.getLocationURI().equals(locationUri)) continue;
            res.add(incl);
        }
        return res;
    }

    @Override
    public void addRedefine(Red red) {
        if (this.redefines == null) {
            this.redefines = new ArrayList<Red>();
        }
        this.redefines.add(red);
    }

    @Override
    public List<Red> getRedefines() {
        if (this.redefines == null) {
            this.redefines = new ArrayList<Red>();
        }
        return this.redefines;
    }

    @Override
    public List<Red> getRedefines(String namespaceURI) {
        ArrayList<AbsItfRedefine> res = new ArrayList<AbsItfRedefine>();
        for (AbsItfRedefine red : this.redefines) {
            if (!red.getLocationURI().toString().equals(namespaceURI)) continue;
            res.add(red);
        }
        return res;
    }

    @Override
    public List<T> getTypes() {
        if (this.types == null) {
            this.types = new ArrayList<T>();
        }
        return this.types;
    }

    @Override
    public T getType(QName type) {
        AbsItfType res = null;
        if (this.types == null) {
            this.types = new ArrayList<T>();
        }
        for (AbsItfType absItfType : this.types) {
            if (!absItfType.getQName().equals(type)) continue;
            res = absItfType;
            break;
        }
        if (res == null && SchemaFactory.getDefaultSchema() != null) {
            for (Object object : SchemaFactory.getDefaultSchema().getTypes()) {
                AbsItfType t = (AbsItfType)object;
                if (!t.getQName().equals(type)) continue;
                res = t;
                break;
            }
        }
        return (T)res;
    }

    @Override
    public void addType(T type) {
        if (this.types == null) {
            this.types = new ArrayList<T>();
        }
        this.types.add(type);
    }

    @Override
    public List<A> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList<A>();
        }
        return this.attributes;
    }

    @Override
    public A getAttribute(QName element) {
        AbsItfAttribute res = null;
        if (this.attributes == null) {
            this.attributes = new ArrayList<A>();
        }
        for (AbsItfAttribute e : this.attributes) {
            if (!e.getName().equals(element.getLocalPart()) || !e.getNamespaceUri().equals(element.getNamespaceURI())) continue;
            res = e;
            break;
        }
        return (A)res;
    }

    @Override
    public void addAttribute(A elmt) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<A>();
        }
        this.attributes.add(elmt);
    }

    @Override
    public List<El> getElements() {
        if (this.elements == null) {
            this.elements = new ArrayList<El>();
        }
        return this.elements;
    }

    @Override
    public El getElement(QName element) {
        AbsItfElement res = null;
        if (this.elements == null) {
            this.elements = new ArrayList<El>();
        }
        for (AbsItfElement e : this.elements) {
            if (!e.getQName().equals(element)) continue;
            res = e;
            break;
        }
        return (El)res;
    }

    @Override
    public List<El> findElementsInAllSchema(QName element) {
        ArrayList<El> res = new ArrayList<El>();
        El elmt = this.getElement(element);
        if (elmt != null) {
            res.add(elmt);
        }
        AbsItfComplexType ct = null;
        for (AbsItfElement elmtA : this.getElements()) {
            if (!(elmtA.getType() instanceof AbsItfComplexType)) continue;
            ct = (AbsItfComplexType)elmtA.getType();
            this.findElmtInComplexType(element, ct, res);
        }
        for (AbsItfType type : this.getTypes()) {
            if (!(type instanceof AbsItfComplexType)) continue;
            ct = (AbsItfComplexType)type;
            this.findElmtInComplexType(element, ct, res);
        }
        return res;
    }

    private void findElmtInComplexType(QName element, AbsItfComplexType ct, List<El> res) {
        if (ct.getSequence() != null) {
            for (AbsItfElement elmtItem : ct.getSequence().getElements()) {
                if (!elmtItem.getQName().equals(element)) continue;
                res.add(elmtItem);
            }
        }
        if (ct.getAll() != null) {
            for (AbsItfElement elmtItem : ct.getAll().getElements()) {
                if (!elmtItem.getQName().equals(element)) continue;
                res.add(elmtItem);
            }
        }
    }

    @Override
    public void addElement(El elmt) {
        if (this.elements == null) {
            this.elements = new ArrayList<El>();
        }
        this.elements.add(elmt);
    }

    @Override
    public NamespaceMapperImpl getAllNamespaces() {
        return this.namespaceMapper;
    }

    public Map<SchemaReader.FeatureConstants, Object> getFeatures() {
        if (this.features == null) {
            this.features = new HashMap<SchemaReader.FeatureConstants, Object>();
        }
        return this.features;
    }

    public void setFeatures(Map<SchemaReader.FeatureConstants, Object> features) {
        this.features = features;
    }

    @Override
    public URI getDocumentURI() {
        return this.documentURI;
    }

    @Override
    public void setDocumentURI(URI documentURI) {
        this.documentURI = documentURI;
    }

    public String toString() {
        return this.model.toString();
    }
}

