/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.encoding;

import fr.dyade.aaa.common.encoding.Encoder;
import java.nio.ByteBuffer;

public class ByteBufferEncoder
implements Encoder {
    private ByteBuffer buf;

    public ByteBufferEncoder(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public void encodeBoolean(boolean bool) throws Exception {
        this.buf.put(bool ? (byte)1 : 0);
    }

    @Override
    public void encodeByte(byte b) throws Exception {
        this.buf.put(b);
    }

    @Override
    public void encodeSignedShort(short s) throws Exception {
        this.buf.putShort(s);
    }

    @Override
    public void encodeUnsignedShort(short s) throws Exception {
        this.buf.putShort(s);
    }

    @Override
    public void encode16(short s) throws Exception {
        this.buf.putShort(s);
    }

    @Override
    public void encodeSignedInt(int i) throws Exception {
        this.buf.putInt(i);
    }

    @Override
    public void encodeUnsignedInt(int i) throws Exception {
        this.buf.putInt(i);
    }

    @Override
    public void encode32(int i) throws Exception {
        this.buf.putInt(i);
    }

    @Override
    public void encodeSignedLong(long l) throws Exception {
        this.buf.putLong(l);
    }

    @Override
    public void encodeUnsignedLong(long l) throws Exception {
        this.buf.putLong(l);
    }

    @Override
    public void encode64(long l) throws Exception {
        this.buf.putLong(l);
    }

    private void encodeNullFlag(Object o) throws Exception {
        if (o == null) {
            this.encodeBoolean(true);
        } else {
            this.encodeBoolean(false);
        }
    }

    @Override
    public void encodeNullableString(String str) throws Exception {
        this.encodeNullFlag(str);
        if (str != null) {
            this.encodeString(str);
        }
    }

    @Override
    public void encodeString(String str) throws Exception {
        byte[] bytes = str.getBytes();
        this.buf.putInt(bytes.length);
        this.buf.put(bytes);
    }

    @Override
    public void encodeNullableByteArray(byte[] tab) throws Exception {
        this.encodeNullFlag(tab);
        if (tab != null) {
            this.encodeByteArray(tab);
        }
    }

    @Override
    public void encodeByteArray(byte[] tab) throws Exception {
        this.buf.putInt(tab.length);
        this.buf.put(tab);
    }

    @Override
    public void encodeNullableByteArray(byte[] tab, int offset, int length) throws Exception {
        this.encodeNullFlag(tab);
        if (tab != null) {
            this.encodeByteArray(tab, offset, length);
        }
    }

    @Override
    public void encodeByteArray(byte[] tab, int offset, int length) throws Exception {
        this.buf.putInt(length);
        this.buf.put(tab, offset, length);
    }

    @Override
    public void encodeFloat(float f) throws Exception {
        this.buf.putFloat(f);
    }

    @Override
    public void encodeDouble(double d) throws Exception {
        this.buf.putDouble(d);
    }
}

