/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common;

import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;

public final class Debug {
    public static final boolean debug = true;
    public static final String DEBUG_DIR_PROPERTY = "fr.dyade.aaa.DEBUG_DIR";
    public static final String DEBUG_FILE_PROPERTY = "fr.dyade.aaa.DEBUG_FILE";
    public static final String DEFAULT_DEBUG_FILE = "a3debug.cfg";
    private static LoggerFactory factory;

    protected static void init() throws Exception {
        try {
            factory = LoggerFactory.initialize();
        }
        catch (Exception exc) {
            System.err.println("Monolog configuration file not found, use defaults");
            throw new Exception("Unable to configure monolog wrapper");
        }
    }

    public static Logger getLogger(String topic) {
        try {
            if (factory == null) {
                Debug.init();
            }
            Logger logger = factory.getLogger(topic);
            return logger;
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static void setLoggerFactory(LoggerFactory loggerFactory) {
    }

    public static void setDebugLevel(String classname) {
        Debug.getLogger(classname).setLevel(BasicLevel.DEBUG);
    }

    public static void setInfoLevel(String classname) {
        Debug.getLogger(classname).setLevel(BasicLevel.INFO);
    }

    public static void setWarnLevel(String classname) {
        Debug.getLogger(classname).setLevel(BasicLevel.WARN);
    }

    public static void setErrorLevel(String classname) {
        Debug.getLogger(classname).setLevel(BasicLevel.ERROR);
    }

    public static void setFatalLevel(String classname) {
        Debug.getLogger(classname).setLevel(BasicLevel.FATAL);
    }

    public static void setLoggerLevel(String classname, String level) throws Exception {
        Debug.getLogger(classname).setLoggerLevel(level);
    }

    public static void clearLevel(String classname) {
        Debug.getLogger(classname).setLevel(null);
    }
}

