/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.encoding;

import fr.dyade.aaa.common.encoding.Decoder;
import fr.dyade.aaa.common.encoding.Encodable;
import fr.dyade.aaa.common.encoding.EncodableFactory;
import fr.dyade.aaa.common.encoding.EncodedString;
import fr.dyade.aaa.common.encoding.Encoder;

public final class StringPair
implements Encodable {
    private EncodedString s1;
    private EncodedString s2;

    public StringPair() {
    }

    public StringPair(EncodedString s1, EncodedString s2) {
        this.s1 = s1;
        this.s2 = s2;
    }

    @Override
    public int getEncodableClassId() {
        return 2;
    }

    @Override
    public int getEncodedSize() {
        return this.s1.getEncodedSize() + this.s2.getEncodedSize();
    }

    @Override
    public void encode(Encoder encoder) throws Exception {
        this.s1.encode(encoder);
        this.s2.encode(encoder);
    }

    @Override
    public void decode(Decoder decoder) throws Exception {
        this.s1 = new EncodedString();
        this.s1.decode(decoder);
        this.s2 = new EncodedString();
        this.s2.decode(decoder);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.s1.getString().length() + 1 + this.s2.getString().length());
        buf.append(this.s1).append('-').append(this.s2);
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.s1 == null ? 0 : this.s1.hashCode());
        result = 31 * result + (this.s2 == null ? 0 : this.s2.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringPair other = (StringPair)obj;
        if (this.s1 == null ? other.s1 != null : !this.s1.equals(other.s1)) {
            return false;
        }
        return !(this.s2 == null ? other.s2 != null : !this.s2.equals(other.s2));
    }

    public static class Factory
    implements EncodableFactory {
        @Override
        public Encodable createEncodable() {
            return new StringPair();
        }
    }
}

