/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.api;

import java.util.logging.Level;
import org.objectweb.util.monolog.api.LogRecord;

public class Logger {
    java.util.logging.Logger logger;

    Logger(String topic) {
        this.logger = java.util.logging.Logger.getLogger(topic);
    }

    public void setLevel(Level level) {
        this.logger.setLevel(level);
    }

    public void setLoggerLevel(String level) throws Exception {
        if (level.equalsIgnoreCase("INHERIT")) {
            this.setLevel(null);
            return;
        }
        try {
            this.setLevel(Level.parse(level));
        }
        catch (Throwable exc) {
            throw new Exception("Cannot set " + this.logger.getName() + " to level " + level + ": " + exc.getMessage());
        }
    }

    public void setLevel(java.util.logging.Logger logger, String level) {
        try {
            logger.setLevel(Level.parse(level));
        }
        catch (Throwable exc) {
            System.err.println("Cannot set " + logger.getName() + " to level " + level + ": " + exc.getMessage());
        }
    }

    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    public void log(Level level, String msg) {
        if (!this.logger.isLoggable(level)) {
            return;
        }
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(this.logger.getName());
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        record.setSourceClassName(stack[2].getClassName());
        record.setSourceMethodName(stack[2].getMethodName());
        record.setSourceLineNumber(stack[2].getLineNumber());
        record.setThreadName(Thread.currentThread().getName());
        this.logger.log(record);
    }

    public void log(Level level, String msg, Throwable t) {
        if (!this.logger.isLoggable(level)) {
            return;
        }
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(this.logger.getName());
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        record.setSourceClassName(stack[2].getClassName());
        record.setSourceMethodName(stack[2].getMethodName());
        record.setSourceLineNumber(stack[2].getLineNumber());
        record.setThreadName(Thread.currentThread().getName());
        record.setThrown(t);
        this.logger.log(record);
    }

    public void log(Level level, String msg, Object param1) {
        if (!this.logger.isLoggable(level)) {
            return;
        }
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(this.logger.getName());
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        record.setSourceClassName(stack[2].getClassName());
        record.setSourceMethodName(stack[2].getMethodName());
        record.setSourceLineNumber(stack[2].getLineNumber());
        record.setThreadName(Thread.currentThread().getName());
        record.setParameters(new Object[]{param1});
        this.logger.log(record);
    }

    public void log(Level level, String msg, Object[] params) {
        if (!this.logger.isLoggable(level)) {
            return;
        }
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(this.logger.getName());
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        record.setSourceClassName(stack[2].getClassName());
        record.setSourceMethodName(stack[2].getMethodName());
        record.setSourceLineNumber(stack[2].getLineNumber());
        record.setThreadName(Thread.currentThread().getName());
        record.setParameters(params);
        this.logger.log(record);
    }
}

