/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.api;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.ExtendedFormatter;
import org.objectweb.util.monolog.api.Logger;

public class LoggerFactory {
    private static boolean debug = Boolean.getBoolean("org.objectweb.util.monolog.debug");
    private static LoggerFactory factory = null;
    private static final String HANDLERS = "handlers";
    private static final String LEVEL = ".level";
    private static final String LOGGER = "logger.";
    private static final String FORMAT = ".format";
    private static final String CONSOLE_HANDLER = "java.util.logging.ConsoleHandler";
    private static final String FILE_HANDLER = "java.util.logging.FileHandler";
    private static final String MEMORY_HANDLER = "java.util.logging.MemoryHandler";
    private static final String SOCKET_HANDLER = "java.util.logging.SocketHandler";
    private static Properties props = new Properties();
    private static HashMap<String, java.util.logging.Logger> sloggers = new HashMap();

    public Logger getLogger(String topic) {
        return new Logger(topic);
    }

    private LoggerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static LoggerFactory initialize() {
        block26: {
            block25: {
                if (LoggerFactory.factory != null) {
                    if (LoggerFactory.debug) {
                        System.err.println("LoggerFactory is already initialized");
                    }
                    return LoggerFactory.factory;
                }
                LoggerFactory.factory = new LoggerFactory();
                BasicLevel.initialize();
                loggerPkg = System.getProperty("jdk.logger.packages");
                if (loggerPkg == null || loggerPkg.isEmpty()) {
                    System.setProperty("jdk.logger.packages", "org.objectweb.util.monolog.api");
                } else {
                    System.setProperty("jdk.logger.packages", loggerPkg + ",org.objectweb.util.monolog.api");
                }
                debugDir = System.getProperty("fr.dyade.aaa.DEBUG_DIR");
                debugFileName = System.getProperty("fr.dyade.aaa.DEBUG_FILE", "a3debug.cfg");
                if (LoggerFactory.debug) {
                    System.err.println("LoggerFactory.initialize: " + debugDir + "/" + debugFileName);
                }
                debugFile = null;
                configStream = null;
                debugFile = debugDir != null ? new File(debugDir, debugFileName) : new File(debugFileName);
                try {
                    if (!debugFile.exists() || !debugFile.isFile() || debugFile.length() == 0L) {
                        throw new IOException();
                    }
                    configStream = new FileInputStream(debugFile);
                }
                catch (IOException exc) {
                    if (!LoggerFactory.debug) break block25;
                    System.err.println("Unable to find \"" + debugFile.getPath() + "\": " + exc.getMessage());
                }
            }
            if (configStream == null) {
                configStream = LoggerFactory.class.getClassLoader().getResourceAsStream(debugFileName);
            }
            if (configStream != null) {
                try {
                    LoggerFactory.configure(configStream);
                    if (LoggerFactory.debug) {
                        System.err.println("Monolog initialized");
                    }
                    exc = LoggerFactory.factory;
                    return exc;
                }
                catch (Throwable exc) {
                    System.err.println("Unable to configure Monolog from file: " + exc.getMessage());
                    if (!LoggerFactory.debug) ** GOTO lbl57
                    exc.printStackTrace();
                }
                finally {
                    try {
                        configStream.close();
                    }
                    catch (IOException var6_10) {}
                }
            } else {
                try {
                    LogManager.getLogManager().readConfiguration();
                }
                catch (Throwable exc) {
                    System.err.println("Unable to configure Monolog: " + exc.getMessage());
                    if (!LoggerFactory.debug) break block26;
                    exc.printStackTrace();
                }
            }
        }
        java.util.logging.Logger.getLogger("").setLevel(Level.SEVERE);
        return LoggerFactory.factory;
    }

    private static void setFilter(Handler handler, String classname) {
        try {
            if (debug) {
                System.err.println("Set handler filter:" + handler + " -> " + classname);
            }
            Class<?> clz = Class.forName(classname);
            Filter filter = (Filter)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            handler.setFilter(filter);
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Error setting filter for " + handler.getClass().getName() + ", class not found: " + classname);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exc) {
            System.err.println("Error setting filter for " + handler.getClass().getName() + ": " + exc.getMessage());
        }
    }

    private static void setFormatter(Handler handler, String classname) {
        block10: {
            try {
                Formatter formatter;
                block9: {
                    String format;
                    Class<?> clz;
                    if (debug) {
                        System.err.println("Set handler formatter:" + handler + " -> " + classname);
                    }
                    if ((formatter = (Formatter)(clz = Class.forName(classname)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) instanceof ExtendedFormatter && (format = props.getProperty(handler.getClass().getName() + FORMAT)) != null) {
                        if (debug) {
                            System.err.println("Use specific format: " + format);
                        }
                        try {
                            ((ExtendedFormatter)((Object)formatter)).setFormat(format);
                        }
                        catch (Exception exc) {
                            System.err.println("Bad format property, use default: " + exc.getMessage());
                            if (!debug) break block9;
                            exc.printStackTrace();
                        }
                    }
                }
                handler.setFormatter(formatter);
            }
            catch (ClassNotFoundException exc) {
                System.err.println("Error setting formatter for " + handler.getClass().getName() + ", class not found: " + classname);
                if (debug) {
                    exc.printStackTrace();
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exc) {
                System.err.println("Error setting formatter for " + handler.getClass().getName() + ": " + exc.getMessage());
                if (!debug) break block10;
                exc.printStackTrace();
            }
        }
    }

    private static Integer getInteger(String name, String dflt) {
        String value = props.getProperty(name, dflt);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (Exception exc) {
            return null;
        }
    }

    private static Handler createHandler(String classname, Properties props) throws Exception {
        Handler handler = null;
        Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(classname);
        if (CONSOLE_HANDLER.equals(classname)) {
            handler = (Handler)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        } else if (FILE_HANDLER.equals(classname)) {
            Integer limit = LoggerFactory.getInteger(classname + ".limit", "0");
            Integer count = LoggerFactory.getInteger(classname + ".count", "1");
            String pattern = props.getProperty(classname + ".pattern", "\"%h/java%u.log\"");
            Boolean append = Boolean.valueOf(props.getProperty(classname + ".append", "false"));
            handler = (Handler)clz.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE).newInstance(pattern, limit, count, append);
        } else if (MEMORY_HANDLER.equals(classname)) {
            Integer size = LoggerFactory.getInteger(classname + ".size", "1000");
            String push = props.getProperty(classname + ".push", "SEVERE");
            String target = props.getProperty(classname + ".target");
            if (target == null) {
                throw new Exception("Cannot instantiate MemoryHandler without target.");
            }
            handler = (Handler)clz.getDeclaredConstructor(String.class, Integer.TYPE, Level.class).newInstance(target, size, Level.parse(push));
        } else if (SOCKET_HANDLER.equals(classname)) {
            String host = props.getProperty(classname + ".host");
            Integer port = LoggerFactory.getInteger(classname + "port", null);
            if (host == null || port == null) {
                throw new Exception("Cannot instantiate SocketHandler, host and/or port should be defined.");
            }
            handler = (Handler)clz.getDeclaredConstructor(String.class, Integer.TYPE).newInstance(host, port);
        } else {
            handler = (Handler)clz.newInstance();
            System.err.println("Warning: " + classname + " not handled, use default properties.");
        }
        String value = props.getProperty(classname + LEVEL);
        if (value != null) {
            if (debug) {
                System.err.println("Set handler level:" + classname + " -> " + value);
            }
            handler.setLevel(Level.parse(value));
        }
        if ((value = props.getProperty(classname + ".filter")) != null) {
            LoggerFactory.setFilter(handler, value);
        }
        if ((value = props.getProperty(classname + ".formatter")) != null) {
            LoggerFactory.setFormatter(handler, value);
        }
        if ((value = props.getProperty(classname + ".encoding")) != null) {
            if (debug) {
                System.err.println("Set handler encoding:" + classname + " -> " + value);
            }
            try {
                handler.setEncoding(value);
            }
            catch (Exception exc) {
                System.err.println("Error setting encoding for " + classname + ": " + exc.getMessage());
            }
        }
        return handler;
    }

    private static boolean isHandlerName(String name, Vector<String> handlers) {
        for (String handler : handlers) {
            if (!name.equals(handler)) continue;
            return true;
        }
        return false;
    }

    static void configure(InputStream is) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        props.clear();
        Vector<String> handlers = null;
        Vector<String> loggers = new Vector<String>();
        Vector<String> levels = new Vector<String>();
        Properties config = new Properties();
        if (debug) {
            System.err.println("Monolog.configure");
        }
        int linenb = 1;
        block20: while (true) {
            try {
                String line = reader.readLine();
                if (line == null) break;
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                int idx = line.indexOf(61);
                if (idx == -1) {
                    throw new Exception("Cannot parse line " + linenb);
                }
                String name = line.substring(0, idx).trim();
                String value = line.substring(idx + 1).trim();
                props.setProperty(name, value);
                if (debug) {
                    System.err.println("line: " + linenb + "read: ##" + name + "##=##" + value + "##");
                }
                if (name.equals(HANDLERS)) {
                    String[] classes;
                    if (handlers == null) {
                        handlers = new Vector<String>();
                    }
                    String[] stringArray = classes = value.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block20;
                        String cn = stringArray[n2];
                        if (debug) {
                            System.err.println("handler: " + cn);
                        }
                        handlers.add(cn.trim());
                        ++n2;
                    }
                }
                if (handlers == null) {
                    throw new Exception("Handlers definition should be first [line #" + linenb + "].");
                }
                if (name.endsWith(LEVEL)) {
                    if (name.startsWith(LOGGER)) {
                        name = name.substring(7);
                    }
                    if ((name = name.substring(0, name.length() - 6)).isEmpty()) {
                        if (debug) {
                            System.err.println("Set root logger: " + value);
                        }
                        java.util.logging.Logger.getLogger("").setLevel(Level.parse(value));
                        continue;
                    }
                    if (debug) {
                        System.err.println("Set logger: " + name + "=" + value);
                    }
                    loggers.add(name);
                    levels.add(value);
                    continue;
                }
                if (!name.endsWith(FORMAT)) continue;
                config.put(name, value);
                continue;
            }
            catch (IOException exc) {
                throw new Exception("Error reading configuration: " + exc.getMessage());
            }
            finally {
                ++linenb;
                continue;
            }
            break;
        }
        LogManager.getLogManager().reset();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            config.store(out, "");
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(out.toByteArray()));
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
        for (String name : handlers) {
            if (debug) {
                System.err.println("Creates handler: " + name);
            }
            Handler handler = LoggerFactory.createHandler(name, props);
            java.util.logging.Logger.getLogger("").addHandler(handler);
        }
        for (int i = 0; i < loggers.size(); ++i) {
            String name;
            name = (String)loggers.get(i);
            if (LoggerFactory.isHandlerName(name, handlers)) continue;
            if (debug) {
                System.err.println("Configure logger: " + name + "=" + (String)levels.get(i));
            }
            Level level = Level.parse((String)levels.get(i));
            java.util.logging.Logger logger = java.util.logging.Logger.getLogger(name);
            sloggers.put(name, logger);
            logger.setLevel(level);
            if (!debug) continue;
            System.err.println("Configure logger: " + logger + " || " + logger.getParent() + " / " + logger.getUseParentHandlers());
        }
        for (String name : loggers) {
            Level level;
            java.util.logging.Logger logger;
            if (debug) {
                System.err.println("##############################");
            }
            if ((logger = java.util.logging.Logger.getLogger(name)) == null) {
                if (!debug) continue;
                System.err.println("## No logger found for " + name);
                continue;
            }
            if (debug) {
                System.err.println("## " + logger + " || " + sloggers.get(name));
            }
            if ((level = logger.getLevel()) == null) {
                if (!debug) continue;
                System.err.println("## No level found for " + name);
                continue;
            }
            if (!debug) continue;
            System.err.println("## " + name + " -> " + level);
        }
    }
}

