/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.jul;

import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.jul.LogRecord;
import org.objectweb.util.monolog.jul.SimpleLevel;

class SimpleLogger
implements Logger {
    java.util.logging.Logger logger;

    SimpleLogger(String topic) {
        this.logger = java.util.logging.Logger.getLogger(topic);
    }

    @Override
    public void setLevel(Level level) {
        this.logger.setLevel((SimpleLevel)level);
    }

    @Override
    public void setLevel(String level) throws Exception {
        if (level == null || level.equalsIgnoreCase("INHERIT")) {
            this.setLevel((Level)null);
            return;
        }
        try {
            this.setLevel((SimpleLevel)SimpleLevel.parse(level));
        }
        catch (Throwable exc) {
            throw new Exception("Cannot set " + this.logger.getName() + " to level " + level + ": " + exc.getMessage());
        }
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.logger.isLoggable((SimpleLevel)level);
    }

    @Override
    public void log(Level level, String msg) {
        if (!this.logger.isLoggable((SimpleLevel)level)) {
            return;
        }
        LogRecord record = new LogRecord((SimpleLevel)level, msg);
        record.setLoggerName(this.logger.getName());
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        record.setSourceClassName(stack[2].getClassName());
        record.setSourceMethodName(stack[2].getMethodName());
        record.setSourceLineNumber(stack[2].getLineNumber());
        record.setThreadName(Thread.currentThread().getName());
        this.logger.log(record);
    }

    @Override
    public void log(Level level, String msg, Throwable t) {
        if (!this.logger.isLoggable((SimpleLevel)level)) {
            return;
        }
        LogRecord record = new LogRecord((SimpleLevel)level, msg);
        record.setLoggerName(this.logger.getName());
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        record.setSourceClassName(stack[2].getClassName());
        record.setSourceMethodName(stack[2].getMethodName());
        record.setSourceLineNumber(stack[2].getLineNumber());
        record.setThreadName(Thread.currentThread().getName());
        record.setThrown(t);
        this.logger.log(record);
    }

    @Override
    public void log(Level level, String msg, Object param1) {
        if (!this.logger.isLoggable((SimpleLevel)level)) {
            return;
        }
        LogRecord record = new LogRecord((SimpleLevel)level, msg);
        record.setLoggerName(this.logger.getName());
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        record.setSourceClassName(stack[2].getClassName());
        record.setSourceMethodName(stack[2].getMethodName());
        record.setSourceLineNumber(stack[2].getLineNumber());
        record.setThreadName(Thread.currentThread().getName());
        record.setParameters(new Object[]{param1});
        this.logger.log(record);
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        if (!this.logger.isLoggable((SimpleLevel)level)) {
            return;
        }
        LogRecord record = new LogRecord((SimpleLevel)level, msg);
        record.setLoggerName(this.logger.getName());
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        record.setSourceClassName(stack[2].getClassName());
        record.setSourceMethodName(stack[2].getMethodName());
        record.setSourceLineNumber(stack[2].getLineNumber());
        record.setThreadName(Thread.currentThread().getName());
        record.setParameters(params);
        this.logger.log(record);
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }
}

