/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.slf4j;

import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.slf4j.Slf4jLoggerLevelSetter;
import org.objectweb.util.monolog.slf4j.Slf4jMonologLevels;
import org.slf4j.Logger;

class Slf4jMonologLogger
implements org.objectweb.util.monolog.api.Logger {
    private final Logger logger;
    private final Slf4jLoggerLevelSetter setter;

    Slf4jMonologLogger(Logger logger, Slf4jLoggerLevelSetter setter) {
        this.logger = logger;
        this.setter = setter;
    }

    @Override
    public void setLevel(Level level) {
        String levelName = Slf4jMonologLevels.of(level).name();
        this.setter.reconfigure(this.logger, levelName);
    }

    @Override
    public void setLevel(String s) {
        String levelName = Slf4jMonologLevels.of(s).name();
        this.setter.reconfigure(this.logger, levelName);
    }

    @Override
    public boolean isLoggable(Level level) {
        return Slf4jMonologLevels.of(level).isLoggable(this.logger);
    }

    @Override
    public void log(Level level, String s) {
        Slf4jMonologLevels.of(level).log(this.logger, s);
    }

    @Override
    public void log(Level level, String s, Throwable throwable) {
        Slf4jMonologLevels.of(level).log(this.logger, s, throwable);
    }

    @Override
    public void log(Level level, String s, Object o) {
        Slf4jMonologLevels.of(level).log(this.logger, s, o);
    }

    @Override
    public void log(Level level, String s, Object[] objects) {
        Slf4jMonologLevels.of(level).log(this.logger, s, objects);
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }
}

