/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common;

import java.io.IOException;
import java.text.DecimalFormat;

public final class BinaryDump {
    public static final String EOL = System.getProperty("line.separator");
    private static final char[] _hexcodes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] _shifts = new int[]{60, 56, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0};

    public static String dump(byte[] data, long offset, int index) {
        if (data == null) {
            return "null";
        }
        if (data.length == 0) {
            return "";
        }
        if (index < 0 || index >= data.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + index + ", length=" + data.length);
        }
        long display_offset = offset + (long)index;
        StringBuilder buffer = new StringBuilder(74);
        for (int j = index; j < data.length; j += 16) {
            int k;
            int chars_read = data.length - j;
            if (chars_read > 16) {
                chars_read = 16;
            }
            buffer.append(BinaryDump.dump(display_offset)).append(' ');
            for (k = 0; k < 16; ++k) {
                if (k < chars_read) {
                    buffer.append(BinaryDump.dump(data[k + j]));
                } else {
                    buffer.append("  ");
                }
                buffer.append(' ');
            }
            for (k = 0; k < chars_read; ++k) {
                if (data[k + j] >= 32 && data[k + j] < 127) {
                    buffer.append((char)data[k + j]);
                    continue;
                }
                buffer.append('.');
            }
            buffer.append(EOL);
            display_offset += (long)chars_read;
        }
        return buffer.toString();
    }

    private static String dump(long value) {
        StringBuilder buf = new StringBuilder();
        buf.setLength(0);
        for (int j = 0; j < 8; ++j) {
            buf.append(_hexcodes[(int)(value >> _shifts[j + _shifts.length - 8]) & 0xF]);
        }
        return buf.toString();
    }

    private static String dump(byte value) {
        StringBuilder buf = new StringBuilder();
        buf.setLength(0);
        for (int j = 0; j < 2; ++j) {
            buf.append(_hexcodes[value >> _shifts[j + 6] & 0xF]);
        }
        return buf.toString();
    }

    public static String toJSon(byte[] data) {
        return BinaryDump.toJSon(data, 0, data.length);
    }

    public static String toJSon(byte[] data, int offset, int length) {
        StringBuilder strbuf = new StringBuilder();
        BinaryDump.toJSon(strbuf, data, offset, length);
        return strbuf.toString();
    }

    public static void toJSon(StringBuilder strbuf, byte[] data) {
        BinaryDump.toJSon(strbuf, data, 0, data.length);
    }

    public static void toJSon(StringBuilder strbuf, byte[] data, int offset, int length) {
        if (data == null) {
            strbuf.append("null");
            return;
        }
        strbuf.append('[');
        for (int i = offset; i < offset + length; ++i) {
            if (i > offset) {
                strbuf.append(',');
            }
            strbuf.append(data[i]);
        }
        strbuf.append(']');
    }

    public static void toJSon(Appendable appendable, byte[] data) throws IOException {
        BinaryDump.toJSon(appendable, data, 0, data.length);
    }

    public static void toJSon(Appendable appendable, byte[] data, int offset, int length) throws IOException {
        if (data == null) {
            appendable.append("null");
            return;
        }
        appendable.append('[');
        for (int i = offset; i < offset + length; ++i) {
            if (i != offset) {
                appendable.append(',');
            }
            appendable.append(Byte.toString(data[i]));
        }
        appendable.append(']');
    }

    public static String toHex(byte[] value) {
        return BinaryDump.toHex(value, 0, value.length);
    }

    public static String toHex(byte[] value, int offset, int length) {
        StringBuilder strbuf = new StringBuilder();
        strbuf.append('[');
        for (int i = offset; i < offset + length; ++i) {
            strbuf.append(BinaryDump.toHex(value[i]));
            strbuf.append(", ");
        }
        strbuf.append(']');
        return strbuf.toString();
    }

    public static String toHex(byte[] value, int bytesPerLine) {
        int digits = (int)Math.round(Math.log(value.length) / Math.log(10.0) + 0.5);
        StringBuilder formatString = new StringBuilder();
        for (int i = 0; i < digits; ++i) {
            formatString.append('0');
        }
        formatString.append(": ");
        DecimalFormat format = new DecimalFormat(formatString.toString());
        StringBuilder retVal = new StringBuilder();
        retVal.append(format.format(0L));
        int i = -1;
        for (int x = 0; x < value.length; ++x) {
            if (++i == bytesPerLine) {
                retVal.append('\n');
                retVal.append(format.format(x));
                i = 0;
            }
            retVal.append(BinaryDump.toHex(value[x]));
            retVal.append(", ");
        }
        return retVal.toString();
    }

    public static String toHex(byte value) {
        return BinaryDump.toHex(value, 2);
    }

    private static String toHex(long value, int digits) {
        StringBuilder result = new StringBuilder(digits);
        for (int j = 0; j < digits; ++j) {
            result.append(_hexcodes[(int)(value >> _shifts[j + (16 - digits)] & 0xFL)]);
        }
        return result.toString();
    }
}

