/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.encoding;

import fr.dyade.aaa.common.encoding.Decoder;
import fr.dyade.aaa.common.encoding.EncodableHelper;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public final class ByteBufferDecoder
implements Decoder {
    private ByteBuffer buf;

    public ByteBufferDecoder(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public short decodeSignedShort() throws Exception {
        return this.buf.getShort();
    }

    @Override
    public short decodeUnsignedShort() throws Exception {
        return this.buf.getShort();
    }

    @Override
    public short decode16() throws Exception {
        return this.buf.getShort();
    }

    @Override
    public int decodeSignedInt() throws Exception {
        return this.buf.getInt();
    }

    @Override
    public int decodeUnsignedInt() throws Exception {
        return this.buf.getInt();
    }

    @Override
    public int decode32() throws Exception {
        return this.buf.getInt();
    }

    @Override
    public long decodeUnsignedLong() throws Exception {
        return this.buf.getLong();
    }

    @Override
    public long decodeSignedLong() throws Exception {
        return this.buf.getLong();
    }

    @Override
    public long decode64() throws Exception {
        return this.buf.getLong();
    }

    private boolean isNull() throws Exception {
        return this.decodeBoolean();
    }

    @Override
    public String decodeNullableString() throws Exception {
        if (this.isNull()) {
            return null;
        }
        return this.decodeString();
    }

    @Override
    public String decodeString() throws Exception {
        int length = this.buf.getInt();
        return this.decodeString(length);
    }

    @Override
    public String decodeString(int length) throws Exception {
        String s;
        if (this.buf.hasArray()) {
            s = new String(this.buf.array(), this.buf.position(), length, EncodableHelper.charset);
            ((Buffer)this.buf).position(this.buf.position() + length);
        } else {
            byte[] bytes = new byte[length];
            this.buf.get(bytes);
            s = new String(bytes, EncodableHelper.charset);
        }
        return s;
    }

    @Override
    public byte decodeByte() throws Exception {
        return this.buf.get();
    }

    @Override
    public byte[] decodeNullableByteArray() throws Exception {
        if (this.isNull()) {
            return null;
        }
        return this.decodeByteArray();
    }

    @Override
    public byte[] decodeByteArray() throws Exception {
        int length = this.buf.getInt();
        return this.decodeByteArray(length);
    }

    @Override
    public byte[] decodeByteArray(int length) throws Exception {
        byte[] bytes = new byte[length];
        this.buf.get(bytes);
        return bytes;
    }

    @Override
    public boolean decodeBoolean() throws Exception {
        byte b = this.buf.get();
        return b != 0;
    }

    @Override
    public float decodeFloat() throws Exception {
        return this.buf.getFloat();
    }

    @Override
    public double decodeDouble() throws Exception {
        return this.buf.getDouble();
    }
}

